/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.draft201909;

import io.vertx.core.json.pointer.impl.JsonPointerImpl;
import io.vertx.json.schema.common.BaseFormatValidatorFactory;
import io.vertx.json.schema.common.RegularExpressions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class FormatValidatorFactory
extends BaseFormatValidatorFactory {
    @Override
    public Map<String, Predicate<String>> initFormatsMap() {
        HashMap<String, Predicate<String>> predicates = new HashMap<String, Predicate<String>>();
        predicates.put("byte", this.createPredicateFromPattern(RegularExpressions.BASE64));
        predicates.put("date", this.createPredicateFromPattern(RegularExpressions.DATE));
        predicates.put("date-time", this.createPredicateFromPattern(RegularExpressions.DATETIME));
        predicates.put("ipv4", this.createPredicateFromPattern(RegularExpressions.IPV4));
        predicates.put("ipv6", this.createPredicateFromPattern(RegularExpressions.IPV6));
        predicates.put("hostname", this.createPredicateFromPattern(RegularExpressions.HOSTNAME));
        predicates.put("email", this.createPredicateFromPattern(RegularExpressions.EMAIL));
        predicates.put("uri", URI_VALIDATOR);
        predicates.put("uri-reference", URI_REFERENCE_VALIDATOR);
        predicates.put("regex", REGEX_VALIDATOR);
        predicates.put("json-pointer", this.createPredicateFromPattern(JsonPointerImpl.VALID_POINTER_PATTERN));
        predicates.put("relative-json-pointer", this.createPredicateFromPattern(RegularExpressions.RELATIVE_JSON_POINTER));
        predicates.put("uri-template", this.createPredicateFromPattern(RegularExpressions.URI_TEMPLATE));
        predicates.put("time", this.createPredicateFromPattern(RegularExpressions.TIME));
        predicates.put("idn-hostname", IDN_HOSTNAME_VALIDATOR);
        predicates.put("idn-email", IDN_EMAIL_VALIDATOR);
        predicates.put("iri", URI_VALIDATOR);
        predicates.put("iri-reference", URI_REFERENCE_VALIDATOR);
        predicates.put("uuid", UUID_VALIDATOR);
        return predicates;
    }
}

