/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.pointer.JsonPointer;
import java.net.URI;
import java.util.UUID;

public class SchemaURNId {
    String id;

    public SchemaURNId(String id) {
        if (!id.matches("[a-zA-Z0-9_-]*")) {
            throw new IllegalArgumentException("Id must match pattern [a-zA-Z0-9_-]*");
        }
        this.id = id;
    }

    public SchemaURNId() {
        this.id = UUID.randomUUID().toString();
    }

    public JsonPointer toPointer() {
        return JsonPointer.fromURI((URI)this.toURI());
    }

    public URI toURI() {
        return URI.create(this.toString());
    }

    public String toString() {
        return "urn:vertxschemas:" + this.id;
    }
}

