/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.json.schema.common.JsonUtil;
import java.util.Objects;
import java.util.function.Predicate;

public enum JsonSchemaType {
    NULL(Objects::isNull),
    BOOLEAN(o -> o instanceof Boolean),
    OBJECT(JsonUtil::isObject),
    ARRAY(JsonUtil::isArray),
    NUMBER(o -> o instanceof Number),
    NUMBER_DECIMAL(o -> o instanceof Double || o instanceof Float),
    INTEGER(o -> o instanceof Long || o instanceof Integer),
    STRING(o -> o instanceof String);

    private final Predicate<Object> checkInstancePredicate;

    private JsonSchemaType(Predicate<Object> checkInstancePredicate) {
        this.checkInstancePredicate = checkInstancePredicate;
    }

    public boolean checkInstance(Object obj) {
        return this.checkInstancePredicate.test(obj);
    }
}

