/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.Future;
import io.vertx.json.schema.NoSyncValidationException;
import io.vertx.json.schema.ValidationException;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.ValidatorContext;
import io.vertx.json.schema.common.ValidatorPriority;

public abstract class BaseMutableStateValidator
implements MutableStateValidator {
    boolean isSync;
    private final MutableStateValidator parent;

    public BaseMutableStateValidator(MutableStateValidator parent) {
        this.parent = parent;
        this.isSync = false;
    }

    public abstract boolean calculateIsSync();

    protected Future<Void> validateSyncAsAsync(ValidatorContext context, Object in) {
        try {
            this.validateSync(context, in);
            this.triggerUpdateIsSync();
            return Future.succeededFuture();
        }
        catch (ValidationException e) {
            return Future.failedFuture((Throwable)((Object)e));
        }
    }

    protected void initializeIsSync() {
        this.isSync = this.calculateIsSync();
    }

    @Override
    public void triggerUpdateIsSync() {
        boolean calculated = this.calculateIsSync();
        boolean previous = this.isSync;
        this.isSync = calculated;
        if (calculated != previous && this.getParent() != null) {
            this.getParent().triggerUpdateIsSync();
        }
    }

    @Override
    public MutableStateValidator getParent() {
        return this.parent;
    }

    protected void checkSync() throws ValidationException, NoSyncValidationException {
        if (!this.isSync) {
            throw new NoSyncValidationException("Trying to execute validateSync() for a Validator in asynchronous state", this);
        }
    }

    @Override
    public boolean isSync() {
        return this.isSync;
    }

    @Override
    public ValidatorPriority getPriority() {
        return ValidatorPriority.NORMAL_PRIORITY;
    }
}

