/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi;

import io.vertx.core.json.JsonObject;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;

public interface DataSourceProvider {
    default public DataSourceProvider init(JsonObject sqlConfig) {
        return this;
    }

    default public JsonObject getInitialConfig() {
        return new JsonObject();
    }

    public int maximumPoolSize(DataSource var1, JsonObject var2) throws SQLException;

    public DataSource getDataSource(JsonObject var1) throws SQLException;

    public void close(DataSource var1) throws SQLException;

    public static DataSourceProvider create(JsonObject config) {
        String providerClass = config.getString("provider_class");
        if (providerClass == null) {
            providerClass = "io.vertx.ext.jdbc.spi.impl.C3P0DataSourceProvider";
        }
        if (Thread.currentThread().getContextClassLoader() != null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(providerClass);
                return ((DataSourceProvider)clazz.newInstance()).init(config);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> clazz = DataSourceProvider.class.getClassLoader().loadClass(providerClass);
            return ((DataSourceProvider)clazz.newInstance()).init(config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static DataSourceProvider create(final DataSource dataSource, final JsonObject config) {
        Objects.requireNonNull(config, "config must not be null");
        return new DataSourceProvider(){

            @Override
            public JsonObject getInitialConfig() {
                return config;
            }

            @Override
            public int maximumPoolSize(DataSource arg0, JsonObject arg1) {
                return config.getInteger("maxPoolSize", Integer.valueOf(-1));
            }

            @Override
            public DataSource getDataSource(JsonObject arg0) {
                return dataSource;
            }

            @Override
            public void close(DataSource arg0) throws SQLException {
                if (dataSource instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)dataSource)).close();
                    }
                    catch (Exception e) {
                        throw new SQLException("Failed to close data source", e);
                    }
                }
            }
        };
    }
}

