/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import io.vertx.ext.jdbc.spi.JDBCColumnDescriptorProvider;
import io.vertx.ext.jdbc.spi.JDBCDecoder;
import io.vertx.ext.sql.SQLRowStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class JDBCSQLRowStream
implements SQLRowStream {
    private static final Logger log = LoggerFactory.getLogger(JDBCSQLRowStream.class);
    private final ContextInternal ctx;
    private final TaskQueue statementsQueue;
    private final Statement st;
    private final int fetchSize;
    private final InboundBuffer<JsonArray> pending;
    private final AtomicBoolean ended = new AtomicBoolean(false);
    private final AtomicBoolean stClosed = new AtomicBoolean(false);
    private final AtomicBoolean rsClosed = new AtomicBoolean(false);
    private final AtomicBoolean more = new AtomicBoolean(false);
    private ResultSet rs;
    private ResultSetMetaData metaData;
    private JDBCDecoder decoder;
    private List<String> columns;
    private int cols;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private Handler<Void> rsClosedHandler;

    JDBCSQLRowStream(ContextInternal ctx, TaskQueue statementsQueue, Statement st, ResultSet rs, JDBCDecoder decoder, int fetchSize) throws SQLException {
        this.ctx = ctx;
        this.statementsQueue = statementsQueue;
        this.st = st;
        this.fetchSize = fetchSize;
        this.rs = rs;
        this.decoder = decoder;
        this.pending = new InboundBuffer((Context)ctx, (long)fetchSize).drainHandler(v -> this.readBatch()).emptyHandler(v -> this.checkEndHandler());
        this.metaData = rs.getMetaData();
        this.cols = this.metaData.getColumnCount();
        this.stClosed.set(false);
        this.rsClosed.set(false);
        this.more.set(true);
    }

    private void checkEndHandler() {
        if (this.ended.get() && this.pending.isEmpty() && this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    @Override
    public int column(String name) {
        try {
            return this.rs.findColumn(name) - 1;
        }
        catch (SQLException e) {
            return -1;
        }
    }

    @Override
    public List<String> columns() {
        if (this.columns == null) {
            try {
                if (this.cols > 0) {
                    ArrayList<String> columns = new ArrayList<String>(this.cols);
                    for (int i = 0; i < this.cols; ++i) {
                        columns.add(i, this.metaData.getColumnLabel(i + 1));
                    }
                    this.columns = Collections.unmodifiableList(columns);
                } else {
                    this.columns = Collections.emptyList();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.columns;
    }

    @Override
    public SQLRowStream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public SQLRowStream handler(Handler<JsonArray> handler) {
        this.pending.handler(handler);
        if (handler != null && this.pending.isWritable()) {
            this.readBatch();
        }
        return this;
    }

    @Override
    public SQLRowStream pause() {
        this.pending.pause();
        return this;
    }

    public ReadStream<JsonArray> fetch(long amount) {
        this.pending.fetch(amount);
        return this;
    }

    @Override
    public SQLRowStream resume() {
        this.pending.resume();
        return this;
    }

    private void readBatch() {
        if (!this.rsClosed.get()) {
            this.ctx.executeBlocking(fut -> {
                try {
                    JDBCColumnDescriptorProvider provider = JDBCColumnDescriptorProvider.fromResultMetaData(this.metaData);
                    ArrayList<JsonArray> rows = new ArrayList<JsonArray>(this.fetchSize);
                    for (int i = 0; i < this.fetchSize && this.rs.next(); ++i) {
                        JsonArray result = new JsonArray();
                        for (int j = 1; j <= this.cols; ++j) {
                            Object res = this.decoder.parse(this.rs, j, provider);
                            if (res != null) {
                                result.add(res);
                                continue;
                            }
                            result.addNull();
                        }
                        rows.add(result);
                    }
                    fut.complete(rows);
                }
                catch (SQLException e) {
                    fut.fail((Throwable)e);
                }
            }, this.statementsQueue, ar -> {
                if (ar.succeeded()) {
                    List rows = (List)ar.result();
                    if (rows.isEmpty()) {
                        this.empty(null);
                    } else if (this.pending.write((Iterable)rows)) {
                        this.readBatch();
                    }
                } else {
                    this.empty(ar.cause());
                }
            });
        }
    }

    private void empty(Throwable err) {
        this.ended.set(true);
        if (this.rsClosedHandler != null) {
            this.closeRS(this.pending.isEmpty(), (Handler<AsyncResult<Void>>)((Handler)c -> {
                if (err != null) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Object)err);
                    } else {
                        log.debug((Object)err);
                    }
                } else {
                    this.rsClosedHandler.handle(null);
                }
            }));
        } else {
            this.closeAll(this.pending.isEmpty(), (Handler<AsyncResult<Void>>)((Handler)c -> {
                if (err != null) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Object)err);
                    } else {
                        log.debug((Object)err);
                    }
                } else {
                    this.checkEndHandler();
                }
            }));
        }
    }

    @Override
    public SQLRowStream endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        this.checkEndHandler();
        return this;
    }

    private void closeRS(boolean pause, Handler<AsyncResult<Void>> handler) {
        if (pause) {
            this.pause();
        }
        this.close(this.rs, this.rsClosed, handler);
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.closeAll(true, handler);
    }

    private void closeAll(boolean pauseBuffer, Handler<AsyncResult<Void>> handler) {
        this.closeRS(pauseBuffer, (Handler<AsyncResult<Void>>)((Handler)res -> this.close(this.st, this.stClosed, handler)));
    }

    @Override
    public SQLRowStream resultSetClosedHandler(Handler<Void> handler) {
        this.rsClosedHandler = handler;
        return this;
    }

    @Override
    public void moreResults() {
        if (this.more.compareAndSet(true, false)) {
            this.pause();
            this.ctx.executeBlocking(this::getNextResultSet, this.statementsQueue, res -> {
                if (res.failed()) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Object)res.cause());
                    } else {
                        log.debug((Object)res.cause());
                    }
                } else if (this.more.get()) {
                    this.resume();
                } else if (this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            });
        }
    }

    private void getNextResultSet(Promise<Void> f) {
        try {
            if (this.rsClosed.compareAndSet(false, true)) {
                this.rs.close();
            }
            if (this.st.getMoreResults()) {
                this.rs = this.st.getResultSet();
                this.metaData = this.rs.getMetaData();
                this.cols = this.metaData.getColumnCount();
                this.columns = null;
                this.stClosed.set(false);
                this.rsClosed.set(false);
                this.more.set(true);
            }
            f.complete();
        }
        catch (SQLException e) {
            f.fail((Throwable)e);
        }
    }

    private void close(AutoCloseable closeable, AtomicBoolean lock, Handler<AsyncResult<Void>> handler) {
        if (lock.compareAndSet(false, true)) {
            this.ctx.executeBlocking(f -> {
                try {
                    closeable.close();
                    f.complete();
                }
                catch (Exception e) {
                    f.fail((Throwable)e);
                }
            }, this.statementsQueue, handler);
        } else if (handler != null) {
            handler.handle((Object)Future.succeededFuture());
        }
    }
}

