/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;

public class CachedParameterMetaData
implements ParameterMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(CachedParameterMetaData.class);
    private final ParameterMetaData delegate;
    private final Map<Integer, QueryMeta> queryMetaMap = new HashMap<Integer, QueryMeta>();

    public CachedParameterMetaData(PreparedStatement statement) {
        ParameterMetaData metaData;
        try {
            metaData = statement.getParameterMetaData();
        }
        catch (SQLFeatureNotSupportedException e) {
            metaData = null;
        }
        catch (SQLException e) {
            LOG.debug((Object)"Driver doesn't support getParameterMetaData()", (Throwable)e);
            metaData = null;
        }
        this.delegate = metaData;
    }

    private QueryMeta getQueryMeta(int param) {
        QueryMeta meta = this.queryMetaMap.get(param);
        if (meta == null) {
            meta = new QueryMeta(param);
            this.queryMetaMap.put(param, meta);
        }
        return meta;
    }

    @Override
    public int getParameterCount() throws SQLException {
        if (this.delegate == null) {
            throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
        }
        return this.delegate.getParameterCount();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getQueryMeta(param).isNullable();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getQueryMeta(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getQueryMeta(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getQueryMeta(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getQueryMeta(param).getParameterType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getQueryMeta(param).getParameterTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getQueryMeta(param).getParameterClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return this.getQueryMeta(param).getParameterMode();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.delegate == null) {
            throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
        }
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.delegate == null) {
            throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
        }
        return this.delegate.isWrapperFor(iface);
    }

    class QueryMeta {
        private final int param;
        private Integer isNullable;
        private Boolean isSigned;
        private Integer getPrecision;
        private Integer getScale;
        private Integer getParameterType;
        private String getParameterTypeName;
        private String getParameterClassName;
        private Integer getParameterMode;

        QueryMeta(int param) {
            this.param = param;
        }

        int isNullable() throws SQLException {
            if (this.isNullable == null) {
                if (CachedParameterMetaData.this.delegate == null) {
                    throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
                }
                this.isNullable = CachedParameterMetaData.this.delegate.isNullable(this.param);
            }
            return this.isNullable;
        }

        boolean isSigned() throws SQLException {
            if (CachedParameterMetaData.this.delegate == null) {
                throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
            }
            if (this.isSigned == null) {
                this.isSigned = CachedParameterMetaData.this.delegate.isSigned(this.param);
            }
            return this.isSigned;
        }

        int getPrecision() throws SQLException {
            if (this.getPrecision == null) {
                if (CachedParameterMetaData.this.delegate == null) {
                    throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
                }
                this.getPrecision = CachedParameterMetaData.this.delegate.getPrecision(this.param);
            }
            return this.getPrecision;
        }

        int getScale() throws SQLException {
            if (this.getScale == null) {
                if (CachedParameterMetaData.this.delegate == null) {
                    throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
                }
                this.getScale = CachedParameterMetaData.this.delegate.getScale(this.param);
            }
            return this.getScale;
        }

        int getParameterType() throws SQLException {
            if (this.getParameterType == null) {
                if (CachedParameterMetaData.this.delegate == null) {
                    throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
                }
                this.getParameterType = CachedParameterMetaData.this.delegate.getParameterType(this.param);
            }
            return this.getParameterType;
        }

        String getParameterTypeName() throws SQLException {
            if (this.getParameterTypeName == null) {
                if (CachedParameterMetaData.this.delegate == null) {
                    throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
                }
                this.getParameterTypeName = CachedParameterMetaData.this.delegate.getParameterTypeName(this.param);
            }
            return this.getParameterTypeName;
        }

        String getParameterClassName() throws SQLException {
            if (this.getParameterClassName == null) {
                if (CachedParameterMetaData.this.delegate == null) {
                    throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
                }
                this.getParameterClassName = CachedParameterMetaData.this.delegate.getParameterClassName(this.param);
            }
            return this.getParameterClassName;
        }

        int getParameterMode() throws SQLException {
            if (this.getParameterMode == null) {
                if (CachedParameterMetaData.this.delegate == null) {
                    throw new SQLFeatureNotSupportedException("getParameterMetaData() unsupported by JDBC driver");
                }
                this.getParameterMode = CachedParameterMetaData.this.delegate.getParameterMode(this.param);
            }
            return this.getParameterMode;
        }
    }
}

