/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.jdbcclient.impl.actions.JDBCQueryAction;
import io.vertx.jdbcclient.impl.actions.JDBCResponse;
import io.vertx.sqlclient.Row;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.stream.Collector;

public class JDBCSimpleQueryAction<C, R>
extends JDBCQueryAction<C, R> {
    private final String sql;

    public JDBCSimpleQueryAction(JDBCStatementHelper helper, SQLOptions options, String sql, Collector<Row, C, R> collector) {
        super(helper, options, collector);
        this.sql = sql;
    }

    @Override
    public JDBCResponse<R> execute(Connection conn) throws SQLException {
        try (Statement statement = conn.createStatement();){
            this.applyStatementOptions(statement);
            JDBCResponse jDBCResponse = this.decode(statement, statement.execute(this.sql), false, Collections.emptyList());
            return jDBCResponse;
        }
    }
}

