/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl.actions;

import io.vertx.ext.jdbc.impl.actions.JDBCTypeWrapper;
import io.vertx.jdbcclient.impl.actions.JDBCPropertyAccessor;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.JDBCType;
import java.sql.SQLException;

public class JDBCColumnDescriptor
implements ColumnDescriptor {
    private final String columnLabel;
    private final JDBCTypeWrapper jdbcTypeWrapper;

    private JDBCColumnDescriptor(String columnLabel, JDBCTypeWrapper jdbcTypeWrapper) {
        this.columnLabel = columnLabel;
        this.jdbcTypeWrapper = jdbcTypeWrapper;
    }

    public String name() {
        return this.columnLabel;
    }

    public boolean isArray() {
        return this.jdbcType() == JDBCType.ARRAY;
    }

    public String typeName() {
        return this.jdbcTypeWrapper.vendorTypeName();
    }

    public JDBCType jdbcType() {
        return this.jdbcTypeWrapper.jdbcType();
    }

    public JDBCTypeWrapper jdbcTypeWrapper() {
        return this.jdbcTypeWrapper;
    }

    public String toString() {
        return "JDBCColumnDescriptor[columnName=(" + this.columnLabel + "), jdbcTypeWrapper=(" + this.jdbcTypeWrapper + ")]";
    }

    public static JDBCColumnDescriptor create(JDBCPropertyAccessor<String> columnLabel, JDBCPropertyAccessor<Integer> vendorTypeNumber, JDBCPropertyAccessor<String> vendorTypeName, JDBCPropertyAccessor<String> vendorTypeClassName) throws SQLException {
        return new JDBCColumnDescriptor(columnLabel.get(), JDBCTypeWrapper.of(vendorTypeNumber.get(), vendorTypeName.get(), vendorTypeClassName.get()));
    }

    public static JDBCColumnDescriptor wrap(JDBCType jdbcType) {
        return new JDBCColumnDescriptor(null, JDBCTypeWrapper.of(jdbcType));
    }
}

