/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.jdbcclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.UUID;

public class JDBCRow
extends ArrayTuple
implements Row {
    private final RowDesc desc;

    public JDBCRow(RowDesc desc) {
        super(desc.columnNames().size());
        this.desc = desc;
    }

    public JDBCRow(JDBCRow row) {
        super((Tuple)row);
        this.desc = row.desc;
    }

    public String getColumnName(int pos) {
        List columnNames = this.desc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.desc.columnNames().indexOf(name);
    }

    public <T> T get(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(pos));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(pos));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(pos));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(pos));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(pos));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(pos));
        }
        if (type == Character.class) {
            return type.cast(this.getChar(pos));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(pos));
        }
        if (type == String.class) {
            return type.cast(this.getString(pos));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(pos));
        }
        if (type == UUID.class) {
            return type.cast(this.getUUID(pos));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(pos));
        }
        if (type == LocalTime.class) {
            return type.cast(this.getLocalTime(pos));
        }
        if (type == OffsetTime.class) {
            return type.cast(this.getOffsetTime(pos));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(pos));
        }
        if (type == OffsetDateTime.class) {
            return type.cast(this.getOffsetDateTime(pos));
        }
        if (type == JsonObject.class) {
            return type.cast(this.getJson(pos));
        }
        if (type == JsonArray.class) {
            return type.cast(this.getJson(pos));
        }
        if (type == Object.class) {
            return type.cast(this.getValue(pos));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public <T> T[] getValues(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return this.getArrayOfBooleans(pos);
        }
        if (type == Short.class) {
            return this.getArrayOfShorts(pos);
        }
        if (type == Integer.class) {
            return this.getArrayOfIntegers(pos);
        }
        if (type == Long.class) {
            return this.getArrayOfLongs(pos);
        }
        if (type == Float.class) {
            return this.getArrayOfFloats(pos);
        }
        if (type == Double.class) {
            return this.getArrayOfDoubles(pos);
        }
        if (type == Character.class) {
            return this.getArrayOfChars(pos);
        }
        if (type == String.class) {
            return this.getArrayOfStrings(pos);
        }
        if (type == Buffer.class) {
            return this.getArrayOfBuffers(pos);
        }
        if (type == UUID.class) {
            return this.getArrayOfUUIDs(pos);
        }
        if (type == LocalDate.class) {
            return this.getArrayOfLocalDates(pos);
        }
        if (type == LocalTime.class) {
            return this.getArrayOfLocalTimes(pos);
        }
        if (type == OffsetTime.class) {
            return this.getArrayOfOffsetTimes(pos);
        }
        if (type == LocalDateTime.class) {
            return this.getArrayOfLocalDateTimes(pos);
        }
        if (type == OffsetDateTime.class) {
            return this.getArrayOfOffsetDateTimes(pos);
        }
        if (type == Object.class) {
            return this.getArrayOfJsons(pos);
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public Numeric getNumeric(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getNumeric(pos);
    }

    public Object[] getArrayOfJsons(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getArrayOfJsons(pos);
    }

    public Numeric[] getArrayOfNumerics(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getArrayOfNumerics(pos);
    }

    public Character[] getArrayOfChars(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getArrayOfChars(pos);
    }

    public Character getChar(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Character) {
            return (Character)val;
        }
        return null;
    }

    public Numeric getNumeric(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Numeric) {
            return (Numeric)val;
        }
        if (val instanceof Number) {
            return Numeric.parse((String)val.toString());
        }
        return null;
    }

    public Object getJson(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonObject) {
            return val;
        }
        if (val instanceof JsonArray) {
            return val;
        }
        return null;
    }

    public Character[] getArrayOfChars(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Character[]) {
            return (Character[])val;
        }
        return null;
    }

    public Object[] getArrayOfJsons(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        return null;
    }

    public Numeric[] getArrayOfNumerics(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Numeric[]) {
            return (Numeric[])val;
        }
        return null;
    }
}

