/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.SocketMetric;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FakeTCPMetrics
extends FakeMetricsBase
implements TCPMetrics<SocketMetric> {
    private final AtomicInteger count = new AtomicInteger();
    private final ConcurrentMap<SocketAddress, SocketMetric[]> sockets = new ConcurrentHashMap<SocketAddress, SocketMetric[]>();

    public int connectionCount() {
        return this.count.get();
    }

    public Integer connectionCount(SocketAddress socket) {
        return this.sockets.getOrDefault(socket, new SocketMetric[0]).length;
    }

    public SocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        SocketMetric metric = new SocketMetric(remoteAddress, remoteName);
        this.sockets.compute(remoteAddress, (key, value) -> {
            if (value == null) {
                value = new SocketMetric[]{metric};
            } else {
                value = Arrays.copyOf(value, ((SocketMetric[])value).length + 1);
                value[value.length - 1] = metric;
            }
            return value;
        });
        this.count.incrementAndGet();
        return metric;
    }

    public void disconnected(SocketMetric socketMetric, SocketAddress remoteAddress) {
        this.sockets.compute(remoteAddress, (key, value) -> {
            if (value != null) {
                for (int idx = 0; idx < ((SocketMetric[])value).length; ++idx) {
                    if (value[idx] != socketMetric) continue;
                    SocketMetric[] next = new SocketMetric[((SocketMetric[])value).length - 1];
                    System.arraycopy(value, 0, next, 0, idx);
                    System.arraycopy(value, idx + 1, next, idx, next.length - idx);
                    if (next.length == 0) {
                        next = null;
                    }
                    return next;
                }
            }
            return null;
        });
        if (socketMetric.connected.compareAndSet(true, false)) {
            this.count.decrementAndGet();
        }
    }

    public SocketMetric firstMetric(SocketAddress address) {
        return ((SocketMetric[])this.sockets.get(address))[0];
    }

    public void bytesRead(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesRead.addAndGet(numberOfBytes);
        socketMetric.bytesReadEvents.add(numberOfBytes);
    }

    public void bytesWritten(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesWritten.addAndGet(numberOfBytes);
        socketMetric.bytesWrittenEvents.add(numberOfBytes);
    }
}

