/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.fakemetrics;

import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class FakePoolMetrics
implements PoolMetrics<Object> {
    private static final Object TASK_SUBMITTED = new Object();
    private static final Object TASK_BEGIN = new Object();
    private static final Map<String, PoolMetrics> METRICS = new ConcurrentHashMap<String, PoolMetrics>();
    private final int poolSize;
    private final AtomicInteger submitted = new AtomicInteger();
    private final AtomicInteger completed = new AtomicInteger();
    private final AtomicInteger idle = new AtomicInteger();
    private final AtomicInteger waiting = new AtomicInteger();
    private final AtomicInteger running = new AtomicInteger();
    private final String name;
    private final AtomicBoolean closed = new AtomicBoolean();

    public FakePoolMetrics(String name, int poolSize) {
        this.poolSize = poolSize;
        this.name = name;
        this.idle.set(this.poolSize);
        METRICS.put(name, this);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getName() {
        return this.name;
    }

    public synchronized Object submitted() {
        this.submitted.incrementAndGet();
        this.waiting.incrementAndGet();
        return TASK_SUBMITTED;
    }

    public void rejected(Object t) {
        this.waiting.decrementAndGet();
    }

    public Object begin(Object t) {
        if (t == TASK_SUBMITTED) {
            this.waiting.decrementAndGet();
            this.idle.decrementAndGet();
            this.running.incrementAndGet();
        }
        return TASK_BEGIN;
    }

    public void end(Object t, boolean succeeded) {
        if (t == TASK_BEGIN) {
            this.running.decrementAndGet();
            this.idle.incrementAndGet();
            this.completed.incrementAndGet();
        }
    }

    public void close() {
        this.closed.set(true);
        METRICS.remove(this.name);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int numberOfSubmittedTask() {
        return this.submitted.get();
    }

    public int numberOfCompletedTasks() {
        return this.completed.get();
    }

    public int numberOfWaitingTasks() {
        return this.waiting.get();
    }

    public int numberOfIdleThreads() {
        return this.idle.get();
    }

    public int numberOfRunningTasks() {
        return this.running.get();
    }

    public static Map<String, PoolMetrics> getPoolMetrics() {
        return METRICS;
    }
}

