/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.SocketAddress;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.TestUtils;
import java.io.File;
import org.junit.Test;

public class TransportTest
extends AsyncTestBase {
    private Vertx vertx;

    @Override
    protected void tearDown() throws Exception {
        this.close(this.vertx);
        super.tearDown();
    }

    @Test
    public void testNoNative() {
        Class<?> clazz2;
        ClassLoader classLoader = Vertx.class.getClassLoader();
        try {
            clazz2 = classLoader.loadClass("io.netty.channel.epoll.Epoll");
            this.fail("Was not expected to load Epoll class from " + clazz2.getProtectionDomain().getCodeSource().getLocation());
        }
        catch (ClassNotFoundException clazz2) {
            // empty catch block
        }
        try {
            clazz2 = classLoader.loadClass("io.netty.channel.kqueue.KQueue");
            this.fail("Was not expected to load KQueue class from " + clazz2.getProtectionDomain().getCodeSource().getLocation());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.testNetServer(new VertxOptions());
        this.assertFalse(this.vertx.isNativeTransportEnabled());
    }

    @Test
    public void testFallbackOnJDK() {
        this.testNetServer(new VertxOptions().setPreferNativeTransport(true));
        this.assertFalse(this.vertx.isNativeTransportEnabled());
    }

    private void testNetServer(VertxOptions options) {
        this.vertx = Vertx.vertx((VertxOptions)options);
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> {
            so.handler(buff -> {
                this.assertEquals("ping", buff.toString());
                so.write("pong");
            });
            so.closeHandler(v -> this.testComplete());
        });
        server.listen(1234, this.onSuccess(v -> {
            NetClient client = this.vertx.createNetClient();
            client.connect(1234, "localhost", this.onSuccess(so -> {
                so.write("ping");
                so.handler(buff -> {
                    this.assertEquals("pong", buff.toString());
                    so.close();
                });
            }));
        }));
        this.await();
    }

    @Test
    public void testDomainSocketServer() throws Exception {
        File sock = TestUtils.tmpFile(".sock");
        this.vertx = Vertx.vertx();
        NetServer server = this.vertx.createNetServer();
        server.connectHandler(so -> {});
        server.listen(SocketAddress.domainSocketAddress((String)sock.getAbsolutePath()), this.onFailure(err -> {
            this.assertEquals(err.getClass(), IllegalArgumentException.class);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDomainSocketClient() throws Exception {
        File sock = TestUtils.tmpFile(".sock");
        this.vertx = Vertx.vertx();
        NetClient client = this.vertx.createNetClient();
        client.connect(SocketAddress.domainSocketAddress((String)sock.getAbsolutePath()), this.onFailure(err -> {
            this.assertEquals(err.getClass(), IllegalArgumentException.class);
            this.testComplete();
        }));
        this.await();
    }
}

