/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PumpTest {
    @Test
    public void testPumpBasic() throws Exception {
        FakeReadStream<MyClass> rs = new FakeReadStream<MyClass>();
        FakeWriteStream ws = new FakeWriteStream();
        Pump p = Pump.pump(rs, ws, (int)1001);
        for (int i = 0; i < 10; ++i) {
            p.start();
            ArrayList<MyClass> inp = new ArrayList<MyClass>();
            for (int j = 0; j < 10; ++j) {
                MyClass myClass = new MyClass();
                inp.add(myClass);
                rs.addData(myClass);
            }
            Assert.assertEquals(inp, ws.received);
            Assert.assertFalse((boolean)((FakeReadStream)rs).paused);
            Assert.assertEquals((long)0L, (long)rs.pauseCount);
            Assert.assertEquals((long)0L, (long)rs.resumeCount);
            p.stop();
            ws.clearReceived();
            MyClass myClass = new MyClass();
            rs.addData(myClass);
            Assert.assertEquals((long)0L, (long)ws.received.size());
        }
    }

    @Test
    public void testPumpPauseResume() throws Exception {
        FakeReadStream<MyClass> rs = new FakeReadStream<MyClass>();
        FakeWriteStream ws = new FakeWriteStream();
        Pump p = Pump.pump(rs, ws, (int)5);
        p.start();
        for (int i = 0; i < 10; ++i) {
            ArrayList<MyClass> inp = new ArrayList<MyClass>();
            for (int j = 0; j < 4; ++j) {
                MyClass myClass = new MyClass();
                inp.add(myClass);
                rs.addData(myClass);
                Assert.assertFalse((boolean)((FakeReadStream)rs).paused);
                Assert.assertEquals((long)i, (long)rs.pauseCount);
                Assert.assertEquals((long)i, (long)rs.resumeCount);
            }
            MyClass myClass = new MyClass();
            inp.add(myClass);
            rs.addData(myClass);
            Assert.assertTrue((boolean)((FakeReadStream)rs).paused);
            Assert.assertEquals((long)(i + 1), (long)rs.pauseCount);
            Assert.assertEquals((long)i, (long)rs.resumeCount);
            Assert.assertEquals(inp, ws.received);
            ws.clearReceived();
            Assert.assertFalse((boolean)((FakeReadStream)rs).paused);
            Assert.assertEquals((long)(i + 1), (long)rs.pauseCount);
            Assert.assertEquals((long)(i + 1), (long)rs.resumeCount);
        }
    }

    @Test(expected=NullPointerException.class)
    public void testPumpReadStreamNull() {
        FakeReadStream rs = new FakeReadStream();
        Pump.pump(rs, null);
    }

    @Test(expected=NullPointerException.class)
    public void testPumpWriteStreamNull() {
        FakeWriteStream ws = new FakeWriteStream();
        Pump.pump(null, ws);
    }

    @Test(expected=NullPointerException.class)
    public void testPumpReadStreamNull2() {
        FakeReadStream rs = new FakeReadStream();
        Pump.pump(rs, null, (int)1000);
    }

    @Test(expected=NullPointerException.class)
    public void testPumpWriteStreamNull2() {
        FakeWriteStream ws = new FakeWriteStream();
        Pump.pump(null, ws, (int)1000);
    }

    static class MyClass {
        MyClass() {
        }
    }

    private class FakeWriteStream<T>
    implements WriteStream<T> {
        int maxSize;
        List<T> received = new ArrayList<T>();
        Handler<Void> drainHandler;

        private FakeWriteStream() {
        }

        void clearReceived() {
            boolean callDrain = this.writeQueueFull();
            this.received = new ArrayList<T>();
            if (callDrain && this.drainHandler != null) {
                this.drainHandler.handle(null);
            }
        }

        public FakeWriteStream setWriteQueueMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public boolean writeQueueFull() {
            return this.received.size() >= this.maxSize;
        }

        public FakeWriteStream drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
            return this;
        }

        public Future<Void> write(T data) {
            Future fut = Future.failedFuture((String)"Not yet implemented");
            this.received.add(data);
            return fut;
        }

        public void write(T data, Handler<AsyncResult<Void>> handler) {
            throw new UnsupportedOperationException();
        }

        public FakeWriteStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        public Future<Void> end() {
            throw new UnsupportedOperationException();
        }

        public void end(Handler<AsyncResult<Void>> handler) {
            throw new UnsupportedOperationException();
        }
    }

    private class FakeReadStream<T>
    implements ReadStream<T> {
        private Handler<T> dataHandler;
        private boolean paused;
        int pauseCount;
        int resumeCount;

        private FakeReadStream() {
        }

        void addData(T data) {
            if (this.dataHandler != null) {
                this.dataHandler.handle(data);
            }
        }

        public FakeReadStream handler(Handler<T> handler) {
            this.dataHandler = handler;
            return this;
        }

        public FakeReadStream pause() {
            this.paused = true;
            ++this.pauseCount;
            return this;
        }

        public ReadStream<T> fetch(long amount) {
            throw new UnsupportedOperationException();
        }

        public FakeReadStream pause(Handler<Void> doneHandler) {
            this.pause();
            doneHandler.handle(null);
            return this;
        }

        public FakeReadStream resume() {
            this.paused = false;
            ++this.resumeCount;
            return this;
        }

        public FakeReadStream resume(Handler<Void> doneHandler) {
            this.resume();
            doneHandler.handle(null);
            return this;
        }

        public FakeReadStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        public FakeReadStream endHandler(Handler<Void> endHandler) {
            return this;
        }
    }
}

