/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.faketracer.FakeTracer;
import io.vertx.test.faketracer.Span;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public abstract class EventBusTracingTestBase
extends VertxTestBase {
    Vertx vertx1;
    Vertx vertx2;
    FakeTracer tracer;

    @Override
    protected VertxTracer getTracer() {
        this.tracer = new FakeTracer();
        return this.tracer;
    }

    @Test
    public void testEventBusSendPropagate() throws Exception {
        this.testSend(TracingPolicy.PROPAGATE, true, 2);
    }

    @Test
    public void testEventBusSendIgnore() throws Exception {
        this.testSend(TracingPolicy.IGNORE, true, 0);
    }

    @Test
    public void testEventBusSendAlways() throws Exception {
        this.testSend(TracingPolicy.ALWAYS, false, 2);
    }

    private void testSend(TracingPolicy policy, boolean create, int expected) throws Exception {
        AtomicInteger received = new AtomicInteger();
        this.vertx2.eventBus().consumer("the-address", msg -> received.incrementAndGet());
        Context ctx = this.vertx1.getOrCreateContext();
        ctx.runOnContext(v -> {
            if (create) {
                this.tracer.activate(this.tracer.newTrace());
            }
            this.vertx1.eventBus().send("the-address", (Object)"ping", new DeliveryOptions().setTracingPolicy(policy));
        });
        EventBusTracingTestBase.assertWaitUntil(() -> this.tracer.getFinishedSpans().size() == expected);
        EventBusTracingTestBase.assertWaitUntil(() -> received.get() == 1);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        this.assertSingleTrace(finishedSpans);
        finishedSpans.forEach(span -> this.assertEquals("send", span.operation));
    }

    @Test
    public void testEventBusPublishProgagate() throws Exception {
        this.testPublish(TracingPolicy.PROPAGATE, true, 3, true);
    }

    @Test
    public void testEventBusPublishIgnore() throws Exception {
        this.testPublish(TracingPolicy.IGNORE, true, 0, false);
    }

    @Test
    public void testEventBusPublishAlways() throws Exception {
        this.testPublish(TracingPolicy.ALWAYS, false, 3, true);
    }

    private void testPublish(TracingPolicy policy, boolean create, int expected, boolean singleTrace) throws Exception {
        this.vertx2.eventBus().consumer("the-address", msg -> {});
        this.vertx2.eventBus().consumer("the-address", msg -> {});
        Context ctx = this.vertx1.getOrCreateContext();
        ctx.runOnContext(v -> {
            if (create) {
                this.tracer.activate(this.tracer.newTrace());
            }
            this.vertx1.eventBus().publish("the-address", (Object)"ping", new DeliveryOptions().setTracingPolicy(policy));
        });
        EventBusTracingTestBase.assertWaitUntil(() -> this.tracer.getFinishedSpans().size() == expected);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        if (singleTrace) {
            this.assertSingleTrace(finishedSpans);
        }
        finishedSpans.forEach(span -> this.assertEquals("publish", span.operation));
    }

    @Test
    public void testEventBusRequestReplyPropagate() throws Exception {
        this.testRequestReply(TracingPolicy.PROPAGATE, true, false, 2);
    }

    @Test
    public void testEventBusRequestReplyIgnore() throws Exception {
        this.testRequestReply(TracingPolicy.IGNORE, true, false, 0);
    }

    @Test
    public void testEventBusRequestReplyAlways() throws Exception {
        this.testRequestReply(TracingPolicy.ALWAYS, false, false, 2);
    }

    @Test
    public void testEventBusRequestReplyFailurePropagate() throws Exception {
        this.testRequestReply(TracingPolicy.PROPAGATE, true, true, 2);
    }

    @Test
    public void testEventBusRequestReplyFailureIgnore() throws Exception {
        this.testRequestReply(TracingPolicy.IGNORE, true, true, 0);
    }

    @Test
    public void testEventBusRequestReplyFailureAlways() throws Exception {
        this.testRequestReply(TracingPolicy.ALWAYS, false, true, 2);
    }

    private void testRequestReply(TracingPolicy policy, boolean create, boolean fail, int expected) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx2.eventBus().consumer("the-address", msg -> {
            if (fail) {
                msg.fail(10, "it failed");
            } else {
                msg.reply((Object)"pong");
            }
        });
        Context ctx = this.vertx1.getOrCreateContext();
        ctx.runOnContext(v -> {
            if (create) {
                this.tracer.activate(this.tracer.newTrace());
            }
            this.vertx1.eventBus().request("the-address", (Object)"ping", new DeliveryOptions().setTracingPolicy(policy), ar -> {
                this.assertEquals(fail, ar.failed());
                this.vertx1.runOnContext(v2 -> latch.countDown());
            });
        });
        this.awaitLatch(latch);
        List<Span> finishedSpans = this.tracer.getFinishedSpans();
        this.assertEquals(expected, finishedSpans.size());
        this.assertSingleTrace(finishedSpans);
        finishedSpans.forEach(span -> this.assertEquals("send", span.operation));
    }

    private void assertSingleTrace(List<Span> spans) {
        for (int i = 1; i < spans.size(); ++i) {
            this.assertEquals(spans.get((int)(i - 1)).traceId, spans.get((int)i).traceId);
        }
    }
}

