/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DuplexChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.Http2TestBase;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpTest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.TestUtils;
import io.vertx.test.tls.Cert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLHandshakeException;
import org.junit.Test;

public class Http2Test
extends HttpTest {
    @Override
    protected HttpServerOptions createBaseServerOptions() {
        return Http2TestBase.createHttp2ServerOptions(8080, "localhost");
    }

    @Override
    protected HttpClientOptions createBaseClientOptions() {
        return Http2TestBase.createHttp2ClientOptions();
    }

    @Override
    @Test
    public void testCloseHandlerNotCalledWhenConnectionClosedAfterEnd() throws Exception {
        this.testCloseHandlerNotCalledWhenConnectionClosedAfterEnd(1);
    }

    @Test
    public void testServerResponseWriteBufferFromOtherThread() {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().write("hello world"))).listen(this.testAddress, this.onSuccess(v -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.handler(buff -> {
                this.assertEquals(Buffer.buffer((String)"hello world"), buff);
                this.testComplete();
            });
        }))))));
        this.await();
    }

    @Test
    public void testServerResponseEndFromOtherThread() {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().end())).listen(this.testAddress, this.onSuccess(v1 -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.endHandler(v2 -> this.testComplete());
        }))))));
        this.await();
    }

    @Test
    public void testServerResponseEndWithTrailersFromOtherThread() {
        this.server.requestHandler(req -> this.runAsync(() -> req.response().putTrailer("some", "trailer").end())).listen(this.testAddress, this.onSuccess(v1 -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            resp.endHandler(v2 -> {
                this.assertEquals(1L, resp.trailers().size());
                this.assertEquals("trailer", resp.trailers().get("some"));
                this.testComplete();
            });
        }))))));
        this.await();
    }

    @Test
    public void testServerResponseResetFromOtherThread() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> this.runAsync(() -> req.response().reset(0L))).listen(this.testAddress, this.onSuccess(v -> this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.response(this.onFailure(err -> {
            this.assertTrue(err instanceof StreamResetException);
            this.complete();
        })).exceptionHandler(err -> {
            this.assertTrue(err instanceof StreamResetException);
            this.complete();
        }).sendHead()))));
        this.await();
    }

    void runAsync(Runnable runnable) {
        new Thread(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.fail(e);
            }
        }).start();
    }

    @Test
    public void testClientRequestWriteFromOtherThread() throws Exception {
        this.disableThreadChecks();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            latch2.countDown();
            req.endHandler(v -> req.response().end());
        }).listen(this.testAddress, this.onSuccess(v -> latch1.countDown()));
        this.awaitLatch(latch1);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.testComplete();
            }));
            req.setChunked(true).sendHead();
            new Thread(() -> {
                try {
                    this.awaitLatch(latch2);
                }
                catch (InterruptedException e) {
                    this.fail(e);
                    return;
                }
                req.write("hello ");
                req.end("world");
            }).start();
        }));
        this.await();
    }

    @Test
    public void testServerOpenSSL() throws Exception {
        HttpServerOptions opts = new HttpServerOptions().setPort(4043).setHost("localhost").setUseAlpn(true).setSsl(true).addEnabledCipherSuite("TLS_RSA_WITH_AES_128_CBC_SHA").setPemKeyCertOptions((PemKeyCertOptions)Cert.SERVER_PEM.get()).setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
        this.server.close();
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.server = this.vertx.createHttpServer(opts);
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testServerStreamPausedWhenConnectionIsPaused() throws Exception {
        CountDownLatch fullLatch = new CountDownLatch(1);
        CompletableFuture resumeLatch = new CompletableFuture();
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            switch (req.path()) {
                case "/0": {
                    this.vertx.setPeriodic(1L, timerID -> {
                        if (resp.writeQueueFull()) {
                            this.vertx.cancelTimer(timerID.longValue());
                            fullLatch.countDown();
                        } else {
                            resp.write((Object)Buffer.buffer((String)TestUtils.randomAlphaString(512)));
                        }
                    });
                    break;
                }
                case "/1": {
                    this.assertTrue(resp.writeQueueFull());
                    resp.drainHandler(v -> resp.end());
                    resumeLatch.complete(null);
                }
            }
        });
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setURI("/0")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            resp.pause();
            Context ctx = this.vertx.getOrCreateContext();
            resumeLatch.thenAccept(v1 -> ctx.runOnContext(v2 -> {
                resp.endHandler(v -> this.testComplete());
                resp.resume();
            }));
        }))));
        this.awaitLatch(fullLatch);
        this.client.request(new RequestOptions(this.requestOptions).setURI("/1")).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> resp.endHandler(v -> this.complete())))));
        resumeLatch.get(20L, TimeUnit.SECONDS);
        this.await();
    }

    @Test
    public void testClientStreamPausedWhenConnectionIsPaused() throws Exception {
        this.waitFor(2);
        Buffer buffer = TestUtils.randomBuffer(512);
        CompletableFuture resumeLatch = new CompletableFuture();
        this.server.requestHandler(req -> {
            switch (req.path()) {
                case "/0": {
                    req.pause();
                    resumeLatch.thenAccept(v -> req.resume());
                    req.endHandler(v -> req.response().end());
                    break;
                }
                case "/1": {
                    req.bodyHandler(v -> {
                        this.assertEquals(v, buffer);
                        req.response().end();
                    });
                }
            }
        });
        this.startServer(this.testAddress);
        Promise l = Promise.promise();
        this.client.request(new RequestOptions(this.requestOptions).setURI("/0")).onComplete(this.onSuccess(req1 -> {
            req1.response(resp -> this.complete()).setChunked(true).sendHead(this.onSuccess(v -> this.vertx.setPeriodic(1L, id -> {
                req1.write((Object)Buffer.buffer((String)TestUtils.randomAlphaString(512)));
                if (req1.writeQueueFull()) {
                    req1.writeQueueFull();
                    this.vertx.cancelTimer(id.longValue());
                    l.complete();
                }
            })));
            l.future().onComplete(this.onSuccess(v -> this.client.request(new RequestOptions(this.requestOptions).setURI("/1")).onComplete(this.onSuccess(req2 -> {
                req2.response(this.onSuccess(resp -> this.complete())).setChunked(true);
                this.assertFalse(req2.writeQueueFull());
                req2.sendHead();
                Http2Test.waitUntil(() -> ((HttpClientRequest)req2).writeQueueFull());
                resumeLatch.complete(null);
                this.waitUntil(() -> !req2.writeQueueFull(), () -> {
                    req1.end();
                    req2.end(buffer);
                });
            }))));
        }));
        this.await();
    }

    private void waitUntil(BooleanSupplier pred, Runnable cont) {
        if (pred.getAsBoolean()) {
            cont.run();
        } else {
            this.vertx.setTimer(1L, id -> this.waitUntil(pred, cont));
        }
    }

    @Test
    public void testResetClientRequestNotYetSent() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setInitialSettings(new Http2Settings().setMaxConcurrentStreams(1L)));
        this.server.requestHandler(req -> this.fail());
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onFailure(err -> this.complete()));
            this.assertTrue(req.reset());
        }));
        this.await();
    }

    @Test
    public void testDiscardConnectionWhenChannelBecomesInactive() throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.server.requestHandler(req -> {
            if (count.getAndIncrement() == 0) {
                Http2ServerConnection a = (Http2ServerConnection)req.connection();
                DuplexChannel channel = (DuplexChannel)a.channel();
                channel.shutdown();
            } else {
                req.response().end();
            }
        });
        this.startServer(this.testAddress);
        AtomicInteger closed = new AtomicInteger();
        this.client.connectionHandler(conn -> conn.closeHandler(v -> closed.incrementAndGet()));
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onFailure(err -> {}))));
        AsyncTestBase.assertWaitUntil(() -> closed.get() == 1);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.testComplete()));
        this.await();
    }

    @Test
    public void testClientDoesNotSupportAlpn() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setProtocolVersion(HttpVersion.HTTP_1_1).setUseAlpn(false));
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testServerDoesNotSupportAlpn() throws Exception {
        this.waitFor(2);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setUseAlpn(false));
        this.server.requestHandler(req -> {
            this.assertEquals(HttpVersion.HTTP_1_1, req.version());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testClientMakeRequestHttp2WithSSLWithoutAlpn() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions().setUseAlpn(false));
        try {
            this.client.request(this.requestOptions);
            this.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testServePendingRequests() throws Exception {
        int n = 10;
        this.waitFor(n);
        LinkedList requests = new LinkedList();
        HashSet connections = new HashSet();
        this.server.requestHandler(req -> {
            requests.add(req);
            connections.add(req.connection());
            this.assertEquals(1L, connections.size());
            if (requests.size() == n) {
                while (requests.size() > 0) {
                    ((HttpServerRequest)requests.removeFirst()).response().end();
                }
            }
        });
        this.startServer(this.testAddress);
        for (int i = 0; i < n; ++i) {
            this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> this.complete()))));
        }
        this.await();
    }

    @Test
    public void testInitialMaxConcurrentStreamZero() throws Exception {
        this.waitFor(2);
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setInitialSettings(new Http2Settings().setMaxConcurrentStreams(0L)));
        this.server.requestHandler(req -> req.response().end());
        this.server.connectionHandler(conn -> this.vertx.setTimer(500L, id -> conn.updateSettings(new Http2Settings().setMaxConcurrentStreams(10L))));
        this.startServer(this.testAddress);
        this.client.connectionHandler(conn -> {
            this.assertEquals(0L, conn.remoteSettings().getMaxConcurrentStreams());
            conn.remoteSettingsHandler(settings -> {
                this.assertEquals(10L, conn.remoteSettings().getMaxConcurrentStreams());
                this.complete();
            });
        });
        this.client.request(new RequestOptions(this.requestOptions).setTimeout(10000L)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> this.complete()));
        this.await();
    }

    @Test
    public void testMaxHaderListSize() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions().setInitialSettings(new Http2Settings().setMaxHeaderListSize(Integer.MAX_VALUE)));
        this.server.requestHandler(req -> req.response().end());
        this.startServer(this.testAddress);
        this.client.request(new RequestOptions(this.requestOptions).setTimeout(10000L)).compose(HttpClientRequest::send).onComplete(this.onSuccess(resp -> {
            this.assertEquals(Integer.MAX_VALUE, resp.request().connection().remoteSettings().getMaxHeaderListSize());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testContentLengthNotRequired() throws Exception {
        this.waitFor(2);
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            resp.write("Hello");
            resp.end("World");
            this.assertNull(resp.headers().get("content-length"));
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions).compose(req -> req.send().compose(resp -> {
            this.assertNull(resp.getHeader("content-length"));
            return resp.body();
        })).onComplete(this.onSuccess(body -> {
            this.assertEquals("HelloWorld", body.toString());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testStreamWeightAndDependency() throws Exception {
        int requestStreamDependency = 56;
        short requestStreamWeight = 43;
        int responseStreamDependency = 98;
        short responseStreamWeight = 55;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(requestStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(requestStreamDependency, req.streamPriority().getDependency());
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency).setWeight(responseStreamWeight).setExclusive(false));
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false)).send(this.onSuccess(resp -> {
            this.assertEquals(responseStreamWeight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(responseStreamDependency, resp.request().getStreamPriority().getDependency());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyChange() throws Exception {
        int requestStreamDependency = 56;
        short requestStreamWeight = 43;
        int requestStreamDependency2 = 157;
        short requestStreamWeight2 = 143;
        int responseStreamDependency = 98;
        short responseStreamWeight = 55;
        int responseStreamDependency2 = 198;
        short responseStreamWeight2 = 155;
        this.waitFor(4);
        this.server.requestHandler(req -> {
            req.streamPriorityHandler(sp -> {
                this.assertEquals(requestStreamWeight2, sp.getWeight());
                this.assertEquals(requestStreamDependency2, sp.getDependency());
                this.assertEquals(requestStreamWeight2, req.streamPriority().getWeight());
                this.assertEquals(requestStreamDependency2, req.streamPriority().getDependency());
                this.complete();
            });
            this.assertEquals(requestStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(requestStreamDependency, req.streamPriority().getDependency());
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency).setWeight(responseStreamWeight).setExclusive(false));
            req.response().write("hello");
            req.response().setStreamPriority(new StreamPriority().setDependency(responseStreamDependency2).setWeight(responseStreamWeight2).setExclusive(false));
            req.response().drainHandler(h -> {});
            req.response().end("world");
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> {
                this.assertEquals(responseStreamWeight, resp.request().getStreamPriority().getWeight());
                this.assertEquals(responseStreamDependency, resp.request().getStreamPriority().getDependency());
                resp.streamPriorityHandler(sp -> {
                    this.assertEquals(responseStreamWeight2, sp.getWeight());
                    this.assertEquals(responseStreamDependency2, sp.getDependency());
                    this.assertEquals(responseStreamWeight2, resp.request().getStreamPriority().getWeight());
                    this.assertEquals(responseStreamDependency2, resp.request().getStreamPriority().getDependency());
                    this.complete();
                });
                this.complete();
            })).setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false));
            req.sendHead(h -> {
                req.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency2).setWeight(requestStreamWeight2).setExclusive(false));
                req.end();
            });
        }));
        this.await();
    }

    @Test
    public void testServerStreamPriorityNoChange() throws Exception {
        int dependency = 56;
        short weight = 43;
        boolean exclusive = true;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.streamPriorityHandler(sp -> this.fail("Stream priority handler should not be called " + sp));
            this.assertEquals(weight, req.streamPriority().getWeight());
            this.assertEquals(dependency, req.streamPriority().getDependency());
            this.assertEquals(exclusive, req.streamPriority().isExclusive());
            req.response().end();
            req.endHandler(v -> this.complete());
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(resp -> resp.endHandler(v -> this.complete())));
            req.setStreamPriority(new StreamPriority().setDependency(dependency).setWeight(weight).setExclusive(exclusive));
            req.sendHead(h -> {
                req.setStreamPriority(new StreamPriority().setDependency(dependency).setWeight(weight).setExclusive(exclusive));
                req.end();
            });
        }));
        this.await();
    }

    @Test
    public void testClientStreamPriorityNoChange() throws Exception {
        int dependency = 98;
        short weight = 55;
        boolean exclusive = false;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            req.response().setStreamPriority(new StreamPriority().setDependency(dependency).setWeight(weight).setExclusive(exclusive));
            req.response().write("hello");
            req.response().setStreamPriority(new StreamPriority().setDependency(dependency).setWeight(weight).setExclusive(exclusive));
            req.response().end("world");
            req.endHandler(v -> this.complete());
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(weight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(dependency, resp.request().getStreamPriority().getDependency());
            this.assertEquals(exclusive, resp.request().getStreamPriority().isExclusive());
            resp.streamPriorityHandler(sp -> this.fail("Stream priority handler should not be called"));
            resp.endHandler(v -> this.complete());
        }))));
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyInheritance() throws Exception {
        int requestStreamDependency = 86;
        short requestStreamWeight = 53;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(requestStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(requestStreamDependency, req.streamPriority().getDependency());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.setStreamPriority(new StreamPriority().setDependency(requestStreamDependency).setWeight(requestStreamWeight).setExclusive(false)).send(this.onSuccess(resp -> {
            this.assertEquals(requestStreamWeight, resp.request().getStreamPriority().getWeight());
            this.assertEquals(requestStreamDependency, resp.request().getStreamPriority().getDependency());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testDefaultStreamWeightAndDependency() throws Exception {
        int defaultStreamDependency = 0;
        short defaultStreamWeight = 16;
        this.waitFor(2);
        this.server.requestHandler(req -> {
            this.assertEquals(defaultStreamWeight, req.streamPriority().getWeight());
            this.assertEquals(defaultStreamDependency, req.streamPriority().getDependency());
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            this.assertEquals(defaultStreamWeight, req.getStreamPriority().getWeight());
            this.assertEquals(defaultStreamDependency, req.getStreamPriority().getDependency());
            this.complete();
        }))));
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyPushPromise() throws Exception {
        int pushStreamDependency = 456;
        short pushStreamWeight = 14;
        this.waitFor(4);
        this.server.requestHandler(req -> {
            req.response().push(HttpMethod.GET, "/pushpath", ar -> {
                this.assertTrue(ar.succeeded());
                HttpServerResponse pushedResp = (HttpServerResponse)ar.result();
                pushedResp.setStreamPriority(new StreamPriority().setDependency(pushStreamDependency).setWeight(pushStreamWeight).setExclusive(false));
                pushedResp.end();
            });
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.pushHandler(pushReq -> {
            this.complete();
            pushReq.response(this.onSuccess(pushResp -> {
                this.assertEquals(pushStreamDependency, pushResp.request().getStreamPriority().getDependency());
                this.assertEquals(pushStreamWeight, pushResp.request().getStreamPriority().getWeight());
                this.complete();
            }));
        }).send(this.onSuccess(resp -> this.complete()))));
        this.await();
    }

    @Test
    public void testStreamWeightAndDependencyInheritancePushPromise() throws Exception {
        int reqStreamDependency = 556;
        short reqStreamWeight = 84;
        this.waitFor(4);
        this.server.requestHandler(req -> {
            req.response().push(HttpMethod.GET, "/pushpath", ar -> {
                this.assertTrue(ar.succeeded());
                HttpServerResponse pushedResp = (HttpServerResponse)ar.result();
                pushedResp.end();
            });
            req.response().end();
            this.complete();
        });
        this.startServer(this.testAddress);
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
        this.client.request(this.requestOptions).onComplete(this.onSuccess(req -> req.pushHandler(pushReq -> {
            this.complete();
            pushReq.response(this.onSuccess(pushResp -> {
                this.assertEquals(reqStreamDependency, pushResp.request().getStreamPriority().getDependency());
                this.assertEquals(reqStreamWeight, pushResp.request().getStreamPriority().getWeight());
                this.complete();
            }));
        }).setStreamPriority(new StreamPriority().setDependency(reqStreamDependency).setWeight(reqStreamWeight).setExclusive(false)).send(this.onSuccess(resp -> this.complete()))));
        this.await();
    }

    @Test
    public void testClearTextUpgradeWithBody() throws Exception {
        this.server.close();
        this.server = this.vertx.createHttpServer().requestHandler(req -> req.bodyHandler(body -> req.response().end(body)));
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2));
        this.client.connectionHandler(conn -> conn.goAwayHandler(ga -> this.assertEquals(0L, ga.getErrorCode())));
        Buffer payload = Buffer.buffer((String)"some-data");
        this.client.request(new RequestOptions(this.requestOptions).setSsl(Boolean.valueOf(false))).onComplete(this.onSuccess(req -> {
            req.response(this.onSuccess(response -> response.body(this.onSuccess(body -> {
                this.assertEquals(Buffer.buffer().appendBuffer(payload).appendBuffer(payload), body);
                this.testComplete();
            }))));
            req.putHeader("Content-Length", "" + payload.length() * 2);
            req.exceptionHandler(this::fail);
            req.write((Object)payload);
            this.vertx.setTimer(1000L, id -> req.end(payload));
        }));
        this.await();
    }

    @Test
    public void testClearTextUpgradeWithBodyTooLongFrameResponse() throws Exception {
        this.server.close();
        Buffer buffer = TestUtils.randomBuffer(1024);
        this.server = this.vertx.createHttpServer().requestHandler(req -> {
            req.response().setChunked(true);
            this.vertx.setPeriodic(1L, id -> req.response().write((Object)buffer));
        });
        this.startServer(this.testAddress);
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2));
        this.client.request(new RequestOptions(this.requestOptions).setSsl(Boolean.valueOf(false))).onComplete(this.onSuccess(req -> {
            req.response(this.onFailure(err -> {}));
            req.setChunked(true);
            req.exceptionHandler(err -> {
                if (err instanceof TooLongFrameException) {
                    this.testComplete();
                }
            });
            req.sendHead();
        }));
        this.await();
    }

    @Test
    public void testSslHandshakeTimeout() throws Exception {
        this.waitFor(2);
        HttpServerOptions opts = this.createBaseServerOptions().setSslHandshakeTimeout(1234L).setSslHandshakeTimeoutUnit(TimeUnit.MILLISECONDS);
        this.server.close();
        this.server = this.vertx.createHttpServer(opts).requestHandler(req -> this.fail("Should not be called")).exceptionHandler(err -> {
            if (err instanceof SSLHandshakeException) {
                this.assertEquals("handshake timed out after 1234ms", err.getMessage());
                this.complete();
            }
        });
        this.startServer();
        this.vertx.createNetClient().connect(8080, "localhost").onFailure(this::fail).onSuccess(so -> so.closeHandler(u -> this.complete()));
        this.await();
    }

    @Test
    public void testAppendToHttpChunks() throws Exception {
        List<String> expected = Arrays.asList("chunk-1", "chunk-2", "chunk-3");
        this.server.requestHandler(req -> {
            HttpServerResponse resp = req.response();
            expected.forEach(arg_0 -> ((HttpServerResponse)resp).write(arg_0));
            resp.end();
        });
        this.startServer(this.testAddress);
        this.client.request(this.requestOptions, this.onSuccess(req -> req.send(this.onSuccess(resp -> {
            ArrayList chunks = new ArrayList();
            resp.handler(chunk -> {
                chunk.appendString("-suffix");
                chunks.add(chunk.toString());
            });
            resp.endHandler(v -> {
                this.assertEquals(Stream.concat(expected.stream(), Stream.of("")).map(s -> s + "-suffix").collect(Collectors.toList()), chunks);
                this.testComplete();
            });
        }))));
        this.await();
    }

    @Test
    public void testNonUpgradedH2CConnectionIsEvictedFromThePool() throws Exception {
        this.client.close();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setProtocolVersion(HttpVersion.HTTP_2));
        this.server.close();
        System.setProperty("vertx.disableH2c", "true");
        this.server = this.vertx.createHttpServer();
        try {
            Promise p = Promise.promise();
            AtomicBoolean first = new AtomicBoolean(true);
            this.server.requestHandler(req -> {
                if (first.compareAndSet(true, false)) {
                    HttpConnection conn = req.connection();
                    p.future().onComplete(ar -> conn.close());
                }
                req.response().end();
            });
            this.startServer(this.testAddress);
            this.client.request(this.requestOptions).compose(req1 -> {
                req1.connection().closeHandler(v1 -> this.vertx.runOnContext(v2 -> this.client.request(this.requestOptions).compose(req2 -> req2.send().compose(HttpClientResponse::body)).onComplete(this.onSuccess(b2 -> this.testComplete()))));
                return req1.send().compose(resp -> {
                    this.assertEquals(HttpVersion.HTTP_1_1, resp.version());
                    return resp.body();
                });
            }).onComplete(this.onSuccess(b -> p.complete()));
            this.await();
        }
        finally {
            System.clearProperty("vertx.disableH2c");
        }
    }

    @Test
    public void testConnectionCloseEvictsConnectionFromThePoolBeforeStreamsAreClosed() throws Exception {
        HashSet serverConnections = new HashSet();
        this.server.requestHandler(req -> {
            serverConnections.add(req.connection());
            switch (req.path()) {
                case "/1": {
                    req.response().end();
                    break;
                }
                case "/2": {
                    this.assertEquals(1L, serverConnections.size());
                    Channel ch = ((ConnectionBase)req.connection()).channel();
                    ChannelPromise promise = ch.newPromise();
                    ch.unsafe().close(promise);
                    break;
                }
                case "/3": {
                    this.assertEquals(2L, serverConnections.size());
                    req.response().end();
                }
            }
        });
        this.startServer(this.testAddress);
        Future f1 = this.client.request(new RequestOptions(this.requestOptions).setURI("/1")).compose(req -> req.send().compose(HttpClientResponse::body));
        f1.onComplete(this.onSuccess(v -> {
            Future f2 = this.client.request(new RequestOptions(this.requestOptions).setURI("/2")).compose(req -> {
                System.out.println(req.connection());
                return req.send().compose(HttpClientResponse::body);
            });
            f2.onComplete(this.onFailure(v2 -> {
                Future f3 = this.client.request(new RequestOptions(this.requestOptions).setURI("/3")).compose(req -> {
                    System.out.println(req.connection());
                    return req.send().compose(HttpClientResponse::body);
                });
                f3.onComplete(this.onSuccess(vvv -> this.testComplete()));
            }));
        }));
        this.await();
    }
}

