/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.netty.buffer.Unpooled;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClientConnectionTest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.impl.ContextInternal;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class Http1xClientConnectionTest
extends HttpClientConnectionTest {
    @Test
    public void testResetStreamBeforeSend() throws Exception {
        this.waitFor(1);
        this.server.requestHandler(req -> {});
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress).onComplete(this.onSuccess(conn -> {
            AtomicInteger evictions = new AtomicInteger();
            conn.evictionHandler(v -> evictions.incrementAndGet());
            conn.createStream((ContextInternal)this.vertx.getOrCreateContext(), this.onSuccess(stream -> {
                Exception cause = new Exception();
                stream.closeHandler(v -> {
                    this.assertEquals(0L, evictions.get());
                    this.complete();
                });
                stream.reset((Throwable)cause);
            }));
        }));
        this.await();
    }

    @Test
    public void testResetStreamRequestSent() throws Exception {
        this.waitFor(1);
        Promise continuation = Promise.promise();
        this.server.requestHandler(req -> continuation.complete());
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress).onComplete(this.onSuccess(conn -> {
            AtomicInteger evictions = new AtomicInteger();
            conn.evictionHandler(v -> evictions.incrementAndGet());
            conn.createStream((ContextInternal)this.vertx.getOrCreateContext(), this.onSuccess(stream -> {
                Exception cause = new Exception();
                stream.closeHandler(v -> {
                    this.assertEquals(1L, evictions.get());
                    this.complete();
                });
                continuation.future().onSuccess(v -> stream.reset((Throwable)cause));
                stream.writeHead(new HttpRequestHead(HttpMethod.GET, "/", MultiMap.caseInsensitiveMultiMap(), "localhost:8080", "", null), false, Unpooled.EMPTY_BUFFER, false, new StreamPriority(), false, null);
            }));
        }));
        this.await();
    }

    @Test
    public void testServerConnectionClose() throws Exception {
        this.waitFor(1);
        this.server.requestHandler(req -> req.response().putHeader("Connection", "close").end());
        this.startServer(this.testAddress);
        this.client.connect(this.testAddress).onComplete(this.onSuccess(conn -> {
            AtomicInteger evictions = new AtomicInteger();
            conn.evictionHandler(v -> this.assertEquals(1L, evictions.incrementAndGet()));
            conn.createStream((ContextInternal)this.vertx.getOrCreateContext(), this.onSuccess(stream -> {
                stream.closeHandler(v -> {
                    this.assertEquals(1L, evictions.get());
                    this.complete();
                });
                stream.writeHead(new HttpRequestHead(HttpMethod.GET, "/", MultiMap.caseInsensitiveMultiMap(), "localhost:8080", "", null), false, Unpooled.EMPTY_BUFFER, true, new StreamPriority(), false, null);
            }));
        }));
        this.await();
    }
}

