/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.core.VertxException;
import io.vertx.core.file.impl.FileCache;
import io.vertx.test.core.VertxTestBase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.junit.Test;

public class FileCacheTest
extends VertxTestBase {
    @Test
    public void testMutateCacheContentOnly() throws IOException {
        File testRoot = File.createTempFile("vertx-", "-cache");
        this.assertTrue(testRoot.delete());
        this.assertTrue(testRoot.mkdirs());
        testRoot.deleteOnExit();
        File cacheRoot = new File(testRoot, "content");
        FileCache cache = new FileCache(cacheRoot);
        File other = new File(testRoot, "content-other");
        Files.write(other.toPath(), "protected".getBytes(), StandardOpenOption.CREATE);
        try {
            cache.cacheFile("../content-other", (InputStream)new ByteArrayInputStream("hello".getBytes()), true);
            this.fail();
        }
        catch (VertxException ignore) {
            this.assertEquals("protected", new String(Files.readAllBytes(other.toPath())));
        }
    }
}

