/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.VertxTestBase;
import java.util.Random;
import org.junit.Test;

public class FileSystemOptionsTest
extends VertxTestBase {
    @Test
    public void testDefaults() {
        FileSystemOptions options = new FileSystemOptions();
        this.assertTrue(options.isFileCachingEnabled());
        this.assertTrue(options.isClassPathResolvingEnabled());
    }

    @Test
    public void testCopy() {
        FileSystemOptions options = new FileSystemOptions();
        Random rand = new Random();
        boolean enabled = rand.nextBoolean();
        options.setFileCachingEnabled(enabled);
        options.setClassPathResolvingEnabled(enabled);
        options = new FileSystemOptions(options);
        this.assertEquals(enabled, options.isClassPathResolvingEnabled());
        this.assertEquals(enabled, options.isFileCachingEnabled());
    }

    @Test
    public void testEmptyJsonOptions() {
        FileSystemOptions options = new FileSystemOptions(new JsonObject());
        this.assertTrue(options.isFileCachingEnabled());
        this.assertTrue(options.isClassPathResolvingEnabled());
    }

    @Test
    public void testJsonOptions() {
        Random rand = new Random();
        boolean enabled = rand.nextBoolean();
        FileSystemOptions options = new FileSystemOptions(new JsonObject().put("fileCachingEnabled", (Object)enabled).put("classPathResolvingEnabled", (Object)enabled));
        this.assertEquals(enabled, options.isFileCachingEnabled());
        this.assertEquals(enabled, options.toJson().getBoolean("fileCachingEnabled"));
        this.assertEquals(enabled, options.isClassPathResolvingEnabled());
        this.assertEquals(enabled, options.toJson().getBoolean("classPathResolvingEnabled"));
    }
}

