/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBusTestBase;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.test.core.VertxTestBase;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

public class ReplyFailureErrorTest
extends VertxTestBase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(2);
    }

    @Test
    public void testUnknownCodec() {
        EventBusTestBase.MyPOJOEncoder2 codec = new EventBusTestBase.MyPOJOEncoder2();
        this.vertices[0].eventBus().registerCodec((MessageCodec)codec);
        this.vertices[1].eventBus().consumer("foo", msg -> this.fail("Should not receive message")).completionHandler(this.onSuccess(v -> {
            DeliveryOptions options = new DeliveryOptions().setCodecName(codec.name());
            this.vertices[0].eventBus().request("foo", (Object)new EventBusTestBase.MyPOJO("bar"), options, this.onFailure(t -> {
                this.assertThat(t, CoreMatchers.instanceOf(ReplyException.class));
                ReplyException e = (ReplyException)t;
                this.assertSame(ReplyFailure.ERROR, e.failureType());
                this.testComplete();
            }));
        }));
        this.await();
    }
}

