/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.buffer.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.buffer.impl.VertxHeapByteBuf;
import io.vertx.core.buffer.impl.VertxUnsafeHeapByteBuf;
import org.junit.Assert;
import org.junit.Test;

public class VertxBufferTest {
    @Test
    public void testAllocateVertxBuffer() {
        BufferImpl buffer = new BufferImpl();
        ByteBuf byteBuf = buffer.byteBuf();
        Assert.assertTrue((byteBuf instanceof VertxHeapByteBuf || byteBuf instanceof VertxUnsafeHeapByteBuf ? 1 : 0) != 0);
    }

    @Test
    public void testUnreleasable() {
        BufferImpl buffer = new BufferImpl();
        ByteBuf byteBuf = buffer.byteBuf();
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        byteBuf.release();
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
    }

    @Test
    public void testDuplicate() {
        BufferImpl buffer = new BufferImpl();
        buffer.appendString("Hello World");
        ByteBuf byteBuf = buffer.byteBuf();
        ByteBuf duplicate = buffer.getByteBuf();
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        duplicate.release();
        Assert.assertEquals((long)1L, (long)duplicate.refCnt());
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        duplicate.readerIndex(3);
        Assert.assertEquals((long)3L, (long)duplicate.readerIndex());
        Assert.assertEquals((long)0L, (long)byteBuf.readerIndex());
        ByteBuf duplicateSlice = duplicate.slice(0, 5);
        duplicateSlice.release();
        Assert.assertEquals((long)1L, (long)duplicateSlice.refCnt());
        Assert.assertEquals((long)1L, (long)duplicate.refCnt());
        Assert.assertEquals((long)1L, (long)byteBuf.refCnt());
        duplicateSlice.readerIndex(1);
        Assert.assertEquals((long)1L, (long)duplicateSlice.readerIndex());
        Assert.assertEquals((long)3L, (long)duplicate.readerIndex());
        Assert.assertEquals((long)0L, (long)byteBuf.readerIndex());
    }
}

