/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.test.core.AsyncTestBase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CustomerLauncherLowMemoryTest {
    private static final String MSG_HOOK = CustomerLauncherLowMemoryTest.class.getSimpleName() + "-hook";
    private Process process;
    private File output;

    @Before
    public void setUp() throws Exception {
        this.output = File.createTempFile(CustomerLauncherLowMemoryTest.class.getSimpleName(), ".txt");
        this.output.deleteOnExit();
    }

    @After
    public void tearDown() throws Exception {
        if (this.process != null) {
            this.process.destroyForcibly();
        }
    }

    @Test
    public void testCloseHookInvoked() throws Exception {
        this.startExternalProcess();
        AsyncTestBase.assertWaitUntil(() -> this.outputContains(MSG_HOOK), 10000L, "Hook not invoked");
        this.stopExternalProcess();
    }

    private void startExternalProcess() throws IOException {
        String javaHome = System.getProperty("java.home");
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaHome + File.separator + "bin" + File.separator + "java");
        command.add("-Xms100M");
        command.add("-Xmx100M");
        command.add("-classpath");
        command.add(classpath);
        command.add(Launcher.class.getName());
        command.add("run");
        command.add(Verticle.class.getName());
        this.process = new ProcessBuilder(command).redirectOutput(this.output).redirectErrorStream(true).start();
    }

    private void stopExternalProcess() throws InterruptedException {
        AtomicBoolean stopped = new AtomicBoolean();
        new Thread(() -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ignore) {
                return;
            }
            if (!stopped.get()) {
                this.process.destroy();
            }
        });
        this.process.waitFor();
        stopped.set(true);
    }

    private boolean outputContains(String line) {
        try {
            return Files.readAllLines(this.output.toPath()).contains(line);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Verticle
    extends AbstractVerticle {
        private final Runtime runtime = Runtime.getRuntime();
        private List<byte[]> arrays;

        public void start() throws Exception {
            this.vertx.executeBlocking(prom -> {
                long l;
                ArrayList<byte[]> res = new ArrayList<byte[]>();
                do {
                    res.add(new byte[5120]);
                } while ((l = this.runtime.freeMemory()) > 0xF00000L);
                this.runtime.gc();
                try {
                    Thread.sleep(100L);
                    prom.complete(res);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    prom.fail((Throwable)e);
                }
            }, ar1 -> {
                if (ar1.succeeded()) {
                    this.arrays = (List)ar1.result();
                    this.context.owner().close();
                } else {
                    ar1.cause().printStackTrace();
                }
            });
        }
    }

    public static class Launcher
    extends io.vertx.core.Launcher {
        public static void main(String[] args) {
            new Launcher().dispatch(args);
        }

        public void beforeStoppingVertx(Vertx vertx) {
            System.out.println(MSG_HOOK);
        }
    }
}

