/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.HttpServerFileUploadImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

final class NettyFileUpload
implements FileUpload {
    private final HttpServerFileUploadImpl upload;
    private final String name;
    private String contentType;
    private String filename;
    private String contentTransferEncoding;
    private Charset charset;
    private boolean completed;
    private long maxSize = -1L;

    NettyFileUpload(HttpServerFileUploadImpl upload, String name, String filename, String contentType, String contentTransferEncoding, Charset charset) {
        this.upload = upload;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
    }

    public void setContent(ByteBuf channelBuffer) throws IOException {
        this.completed = true;
        this.upload.receiveData(Buffer.buffer(channelBuffer));
        this.upload.complete();
    }

    public void addContent(ByteBuf channelBuffer, boolean last) throws IOException {
        this.upload.receiveData(Buffer.buffer(channelBuffer));
        if (last) {
            this.completed = true;
            this.upload.complete();
        }
    }

    public void setContent(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setContent(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public long length() {
        throw new UnsupportedOperationException();
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public long definedLength() {
        throw new UnsupportedOperationException();
    }

    public void checkSize(long newSize) throws IOException {
        if (this.maxSize >= 0L && newSize > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public byte[] get() throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteBuf getChunk(int i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getString() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getString(Charset charset) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean renameTo(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isInMemory() {
        return false;
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(InterfaceHttpData o) {
        return 0;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public ByteBuf getByteBuf() throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileUpload copy() {
        throw new UnsupportedOperationException();
    }

    public FileUpload duplicate() {
        throw new UnsupportedOperationException();
    }

    public FileUpload retainedDuplicate() {
        throw new UnsupportedOperationException();
    }

    public FileUpload replace(ByteBuf content) {
        throw new UnsupportedOperationException();
    }

    public FileUpload retain() {
        return this;
    }

    public FileUpload retain(int increment) {
        return this;
    }

    public FileUpload touch(Object hint) {
        return this;
    }

    public FileUpload touch() {
        return this;
    }

    public ByteBuf content() {
        throw new UnsupportedOperationException();
    }

    public int refCnt() {
        return 1;
    }

    public boolean release() {
        return false;
    }

    public boolean release(int decrement) {
        return false;
    }
}

