/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.file.FileSystemOptionsConverter;
import io.vertx.core.json.JsonObject;

@DataObject(generateConverter=true, publicConverter=false)
public class FileSystemOptions {
    public static final boolean DEFAULT_FILE_CACHING_ENABLED = !Boolean.getBoolean("vertx.disableFileCaching");
    public static final boolean DEFAULT_CLASS_PATH_RESOLVING_ENABLED = !Boolean.getBoolean("vertx.disableFileCPResolving");
    private boolean classPathResolvingEnabled = DEFAULT_CLASS_PATH_RESOLVING_ENABLED;
    private boolean fileCachingEnabled = DEFAULT_FILE_CACHING_ENABLED;

    public FileSystemOptions() {
    }

    public FileSystemOptions(FileSystemOptions other) {
        this.classPathResolvingEnabled = other.isClassPathResolvingEnabled();
        this.fileCachingEnabled = other.isFileCachingEnabled();
    }

    public FileSystemOptions(JsonObject json) {
        this();
        FileSystemOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        FileSystemOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isClassPathResolvingEnabled() {
        return this.classPathResolvingEnabled;
    }

    public FileSystemOptions setClassPathResolvingEnabled(boolean classPathResolvingEnabled) {
        this.classPathResolvingEnabled = classPathResolvingEnabled;
        return this;
    }

    public boolean isFileCachingEnabled() {
        return this.fileCachingEnabled;
    }

    public FileSystemOptions setFileCachingEnabled(boolean fileCachingEnabled) {
        this.fileCachingEnabled = fileCachingEnabled;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemOptions that = (FileSystemOptions)o;
        if (this.classPathResolvingEnabled != that.isClassPathResolvingEnabled()) {
            return false;
        }
        return this.fileCachingEnabled == that.isFileCachingEnabled();
    }

    public int hashCode() {
        int result = this.classPathResolvingEnabled ? 1 : 0;
        return 31 * (result += this.fileCachingEnabled ? 1 : 0);
    }

    public String toString() {
        return "FileSystemOptions{classPathResolvingEnabled=" + this.classPathResolvingEnabled + ", fileCachingEnabled=" + this.fileCachingEnabled + '}';
    }
}

