/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.vertx.config.spi.ConfigProcessor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonObject;

public class YamlProcessor
implements ConfigProcessor {
    public static ObjectMapper YAML_MAPPER = new YAMLMapper();

    public String name() {
        return "yaml";
    }

    public Future<JsonObject> process(Vertx vertx, JsonObject configuration, Buffer input) {
        if (input.length() == 0) {
            return ((ContextInternal)vertx.getOrCreateContext()).succeededFuture((Object)new JsonObject());
        }
        return vertx.executeBlocking(promise -> {
            try {
                JsonNode root = YAML_MAPPER.readTree(input.toString("utf-8"));
                JsonObject json = new JsonObject(root.toString());
                promise.complete((Object)json);
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        });
    }
}

