/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodPredicate
implements Predicate {
    private final HttpString[] methods;

    MethodPredicate(String[] methods) {
        HttpString[] values = new HttpString[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            values[i] = HttpString.tryFromString(methods[i]);
        }
        this.methods = values;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!value.getRequestMethod().equals(this.methods[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.methods.length == 1) {
            return "method( '" + String.valueOf(this.methods[0]) + "' )";
        }
        return "method( {" + Arrays.asList(this.methods).stream().map(s -> s.toString()).collect(Collectors.joining(", ")) + "} )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "method";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("value", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] methods = (String[])config.get("value");
            return new MethodPredicate(methods);
        }
    }
}

