/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.type;

import com.google.common.collect.ImmutableMap;
import io.trino.tpcds.TpcdsException;
import io.trino.tpcds.generator.CatalogSalesGeneratorColumn;
import io.trino.tpcds.generator.GeneratorColumn;
import io.trino.tpcds.generator.StoreSalesGeneratorColumn;
import io.trino.tpcds.generator.WebSalesGeneratorColumn;
import io.trino.tpcds.random.RandomNumberStream;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.generator.CatalogSalesRowGenerator;
import io.trino.tpcds.type.Decimal;
import java.util.Map;

public class Pricing {
    public static final int QUANTITY_MIN = 1;
    public static final Decimal MARKUP_MIN = new Decimal(0L, 2);
    public static final Decimal DISCOUNT_MIN = new Decimal(0L, 2);
    private static final Map<GeneratorColumn, Limits> LIMITS_PER_COLUMN = ImmutableMap.of((Object)CatalogSalesGeneratorColumn.CS_PRICING, (Object)new Limits(100, CatalogSalesRowGenerator.CS_MARKUP_MAX, CatalogSalesRowGenerator.CS_DISCOUNT_MAX, CatalogSalesRowGenerator.CS_WHOLESALE_MAX), (Object)StoreSalesGeneratorColumn.SS_PRICING, (Object)new Limits(100, Decimal.ONE, Decimal.ONE, Decimal.ONE_HUNDRED), (Object)WebSalesGeneratorColumn.WS_PRICING, (Object)new Limits(100, new Decimal(200L, 2), Decimal.ONE, Decimal.ONE_HUNDRED));
    private final Decimal wholesaleCost;
    private final Decimal listPrice;
    private final Decimal salesPrice;
    private final int quantity;
    private final Decimal extDiscountAmount;
    private final Decimal extSalesPrice;
    private final Decimal extWholesaleCost;
    private final Decimal extListPrice;
    private final Decimal taxPercent;
    private final Decimal extTax;
    private final Decimal couponAmount;
    private final Decimal shipCost;
    private final Decimal extShipCost;
    private final Decimal netPaid;
    private final Decimal netPaidIncludingTax;
    private final Decimal netPaidIncludingShipping;
    private final Decimal netPaidIncludingShippingAndTax;
    private final Decimal netProfit;
    private final Decimal refundedCash;
    private final Decimal reversedCharge;
    private final Decimal storeCredit;
    private final Decimal fee;
    private final Decimal netLoss;

    private Pricing(Decimal wholesaleCost, Decimal listPrice, Decimal salesPrice, int quantity, Decimal extDiscountAmount, Decimal extSalesPrice, Decimal extWholesaleCost, Decimal extListPrice, Decimal taxPercent, Decimal extTax, Decimal couponAmount, Decimal shipCost, Decimal extShipCost, Decimal netPaid, Decimal netPaidIncludingTax, Decimal netPaidIncludingShipping, Decimal netPaidIncludingShippingAndTax, Decimal netProfit, Decimal refundedCash, Decimal reversedCharge, Decimal storeCredit, Decimal fee, Decimal netLoss) {
        this.wholesaleCost = wholesaleCost;
        this.listPrice = listPrice;
        this.salesPrice = salesPrice;
        this.quantity = quantity;
        this.extDiscountAmount = extDiscountAmount;
        this.extSalesPrice = extSalesPrice;
        this.extWholesaleCost = extWholesaleCost;
        this.extListPrice = extListPrice;
        this.taxPercent = taxPercent;
        this.extTax = extTax;
        this.couponAmount = couponAmount;
        this.shipCost = shipCost;
        this.extShipCost = extShipCost;
        this.netPaid = netPaid;
        this.netPaidIncludingTax = netPaidIncludingTax;
        this.netPaidIncludingShipping = netPaidIncludingShipping;
        this.netPaidIncludingShippingAndTax = netPaidIncludingShippingAndTax;
        this.netProfit = netProfit;
        this.refundedCash = refundedCash;
        this.reversedCharge = reversedCharge;
        this.storeCredit = storeCredit;
        this.fee = fee;
        this.netLoss = netLoss;
    }

    public static Pricing generatePricingForSalesTable(GeneratorColumn column, RandomNumberStream randomNumberStream) {
        if (!LIMITS_PER_COLUMN.containsKey(column)) {
            throw new TpcdsException("No price limits for column: " + column);
        }
        Limits limits = LIMITS_PER_COLUMN.get(column);
        int quantity = RandomValueGenerator.generateUniformRandomInt(1, limits.getMaxQuantitySold(), randomNumberStream);
        Decimal decimalQuantity = Decimal.fromInteger(quantity);
        Decimal wholesaleCost = RandomValueGenerator.generateUniformRandomDecimal(new Decimal(100L, 2), limits.getMaxWholesaleCost(), randomNumberStream);
        Decimal extWholesaleCost = Decimal.multiply(decimalQuantity, wholesaleCost);
        Decimal markup = RandomValueGenerator.generateUniformRandomDecimal(MARKUP_MIN, limits.getMaxMarkup(), randomNumberStream);
        markup = Decimal.add(markup, Decimal.ONE);
        Decimal listPrice = Decimal.multiply(wholesaleCost, markup);
        Decimal discount = Decimal.negate(RandomValueGenerator.generateUniformRandomDecimal(DISCOUNT_MIN, limits.getMaxDiscount(), randomNumberStream));
        discount = Decimal.add(discount, Decimal.ONE);
        Decimal salesPrice = Decimal.multiply(listPrice, discount);
        Decimal extListPrice = Decimal.multiply(listPrice, decimalQuantity);
        Decimal extSalesPrice = Decimal.multiply(salesPrice, decimalQuantity);
        Decimal extDiscountAmount = Decimal.subtract(extListPrice, extSalesPrice);
        Decimal coupon = RandomValueGenerator.generateUniformRandomDecimal(Decimal.ZERO, Decimal.ONE, randomNumberStream);
        int couponUsage = RandomValueGenerator.generateUniformRandomInt(1, 100, randomNumberStream);
        Decimal couponAmount = couponUsage <= 20 ? Decimal.multiply(extSalesPrice, coupon) : Decimal.ZERO;
        Decimal netPaid = Decimal.subtract(extSalesPrice, couponAmount);
        Decimal shipping = RandomValueGenerator.generateUniformRandomDecimal(Decimal.ZERO, Decimal.ONE_HALF, randomNumberStream);
        Decimal shipCost = Decimal.multiply(listPrice, shipping);
        Decimal extShipCost = Decimal.multiply(shipCost, decimalQuantity);
        Decimal netPaidIncludingShipping = Decimal.add(netPaid, extShipCost);
        Decimal taxPercent = RandomValueGenerator.generateUniformRandomDecimal(Decimal.ZERO, Decimal.NINE_PERCENT, randomNumberStream);
        Decimal extTax = Decimal.multiply(netPaid, taxPercent);
        Decimal netPaidIncludingTax = Decimal.add(netPaid, extTax);
        Decimal netPaidIncludingShippingAndTax = Decimal.add(netPaidIncludingShipping, extTax);
        Decimal netProfit = Decimal.subtract(netPaid, extWholesaleCost);
        Decimal refundedCash = Decimal.ZERO;
        Decimal reversedCharge = Decimal.ZERO;
        Decimal storeCredit = Decimal.ZERO;
        Decimal fee = Decimal.ZERO;
        Decimal netLoss = Decimal.ZERO;
        return new Pricing(wholesaleCost, listPrice, salesPrice, quantity, extDiscountAmount, extSalesPrice, extWholesaleCost, extListPrice, taxPercent, extTax, couponAmount, shipCost, extShipCost, netPaid, netPaidIncludingTax, netPaidIncludingShipping, netPaidIncludingShippingAndTax, netProfit, refundedCash, reversedCharge, storeCredit, fee, netLoss);
    }

    public static Pricing generatePricingForReturnsTable(GeneratorColumn column, RandomNumberStream randomNumberStream, int quantity, Pricing basePricing) {
        Decimal extSalesPrice;
        Decimal wholesaleCost = basePricing.wholesaleCost;
        Decimal listPrice = basePricing.listPrice;
        Decimal salesPrice = basePricing.salesPrice;
        Decimal taxPercent = basePricing.taxPercent;
        Decimal extDiscountAmount = basePricing.extDiscountAmount;
        Decimal couponAmount = basePricing.couponAmount;
        Decimal decimalQuantity = Decimal.fromInteger(quantity);
        Decimal extWholesaleCost = Decimal.multiply(decimalQuantity, wholesaleCost);
        Decimal extListPrice = Decimal.multiply(listPrice, decimalQuantity);
        Decimal netPaid = extSalesPrice = Decimal.multiply(salesPrice, decimalQuantity);
        Decimal shipping = RandomValueGenerator.generateUniformRandomDecimal(Decimal.ZERO, Decimal.ONE_HALF, randomNumberStream);
        Decimal shipCost = Decimal.multiply(listPrice, shipping);
        Decimal extShipCost = Decimal.multiply(shipCost, decimalQuantity);
        Decimal netPaidIncludingShipping = Decimal.add(netPaid, extShipCost);
        Decimal extTax = Decimal.multiply(netPaid, taxPercent);
        Decimal netPaidIncludingTax = Decimal.add(netPaid, extTax);
        Decimal netPaidIncludingShippingAndTax = Decimal.add(netPaidIncludingShipping, extTax);
        Decimal netProfit = Decimal.subtract(netPaid, extWholesaleCost);
        Decimal cashPercentage = Decimal.fromInteger(RandomValueGenerator.generateUniformRandomInt(0, 100, randomNumberStream));
        Decimal refundedCash = Decimal.multiply(Decimal.divide(cashPercentage, Decimal.ONE_HUNDRED), netPaid);
        Decimal creditPercent = Decimal.fromInteger(RandomValueGenerator.generateUniformRandomInt(1, 100, randomNumberStream));
        creditPercent = Decimal.divide(creditPercent, Decimal.ONE_HUNDRED);
        Decimal paidMinusRefunded = Decimal.subtract(netPaid, refundedCash);
        Decimal reversedCharge = Decimal.multiply(creditPercent, paidMinusRefunded);
        Decimal storeCredit = Decimal.subtract(netPaid, reversedCharge);
        storeCredit = Decimal.subtract(storeCredit, refundedCash);
        Decimal fee = RandomValueGenerator.generateUniformRandomDecimal(Decimal.ONE_HALF, Decimal.ONE_HUNDRED, randomNumberStream);
        Decimal netLoss = Decimal.subtract(netPaidIncludingShippingAndTax, storeCredit);
        netLoss = Decimal.subtract(netLoss, refundedCash);
        netLoss = Decimal.subtract(netLoss, reversedCharge);
        netLoss = Decimal.add(netLoss, fee);
        return new Pricing(wholesaleCost, listPrice, salesPrice, quantity, extDiscountAmount, extSalesPrice, extWholesaleCost, extListPrice, taxPercent, extTax, couponAmount, shipCost, extShipCost, netPaid, netPaidIncludingTax, netPaidIncludingShipping, netPaidIncludingShippingAndTax, netProfit, refundedCash, reversedCharge, storeCredit, fee, netLoss);
    }

    public Decimal getNetLoss() {
        return this.netLoss;
    }

    public Decimal getExtDiscountAmount() {
        return this.extDiscountAmount;
    }

    public Decimal getExtSalesPrice() {
        return this.extSalesPrice;
    }

    public Decimal getExtWholesaleCost() {
        return this.extWholesaleCost;
    }

    public Decimal getExtListPrice() {
        return this.extListPrice;
    }

    public Decimal getTaxPercent() {
        return this.taxPercent;
    }

    public Decimal getExtTax() {
        return this.extTax;
    }

    public Decimal getCouponAmount() {
        return this.couponAmount;
    }

    public Decimal getShipCost() {
        return this.shipCost;
    }

    public Decimal getExtShipCost() {
        return this.extShipCost;
    }

    public Decimal getNetPaid() {
        return this.netPaid;
    }

    public Decimal getNetPaidIncludingTax() {
        return this.netPaidIncludingTax;
    }

    public Decimal getNetPaidIncludingShipping() {
        return this.netPaidIncludingShipping;
    }

    public Decimal getNetPaidIncludingShippingAndTax() {
        return this.netPaidIncludingShippingAndTax;
    }

    public Decimal getNetProfit() {
        return this.netProfit;
    }

    public Decimal getRefundedCash() {
        return this.refundedCash;
    }

    public Decimal getReversedCharge() {
        return this.reversedCharge;
    }

    public Decimal getStoreCredit() {
        return this.storeCredit;
    }

    public Decimal getFee() {
        return this.fee;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public Decimal getWholesaleCost() {
        return this.wholesaleCost;
    }

    public Decimal getListPrice() {
        return this.listPrice;
    }

    public Decimal getSalesPrice() {
        return this.salesPrice;
    }

    private static class Limits {
        private final int maxQuantitySold;
        private final Decimal maxMarkup;
        private final Decimal maxDiscount;
        private final Decimal maxWholesaleCost;

        Limits(int maxQuantitySold, Decimal maxMarkup, Decimal maxDiscount, Decimal maxWholesaleCost) {
            this.maxQuantitySold = maxQuantitySold;
            this.maxMarkup = maxMarkup;
            this.maxDiscount = maxDiscount;
            this.maxWholesaleCost = maxWholesaleCost;
        }

        Decimal getMaxDiscount() {
            return this.maxDiscount;
        }

        int getMaxQuantitySold() {
            return this.maxQuantitySold;
        }

        Decimal getMaxMarkup() {
            return this.maxMarkup;
        }

        Decimal getMaxWholesaleCost() {
            return this.maxWholesaleCost;
        }
    }
}

