/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.generator.CatalogPageGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.CatalogPageRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Date;

public class CatalogPageRowGenerator
extends AbstractRowGenerator {
    public static final int CATALOGS_PER_YEAR = 18;
    private static final int WIDTH_CP_DESCRIPTION = 100;

    public CatalogPageRowGenerator() {
        super(Table.CATALOG_PAGE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        int offset;
        int duration;
        String cpType;
        long cpCatalogPageSk = rowNumber;
        String cpDepartment = "DEPARTMENT";
        long nullBitMap = Nulls.createNullBitMap(Table.CATALOG_PAGE, this.getRandomNumberStream(CatalogPageGeneratorColumn.CP_NULLS));
        String cpCatalogPageId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        int catalogPageMax = (int)(session.getScaling().getRowCount(Table.CATALOG_PAGE) / 18L) / (Date.DATE_MAXIMUM.getYear() - Date.DATE_MINIMUM.getYear() + 2);
        int cpCatalogNumber = (int)((rowNumber - 1L) / (long)catalogPageMax + 1L);
        int cpCatalogPageNumber = (int)((rowNumber - 1L) % (long)catalogPageMax + 1L);
        int catalogInterval = (cpCatalogNumber - 1) % 18;
        switch (catalogInterval) {
            case 0: 
            case 1: {
                cpType = "bi-annual";
                duration = 182;
                offset = catalogInterval * duration;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                cpType = "quarterly";
                duration = 91;
                offset = (catalogInterval - 2) * duration;
                break;
            }
            default: {
                cpType = "monthly";
                duration = 30;
                offset = (catalogInterval - 6) * duration;
            }
        }
        long cpStartDateId = Date.JULIAN_DATA_START_DATE + offset + (cpCatalogNumber - 1) / 18 * 365;
        long cpEndDateId = cpStartDateId + (long)duration - 1L;
        String cpDescription = RandomValueGenerator.generateRandomText(50, 99, this.getRandomNumberStream(CatalogPageGeneratorColumn.CP_DESCRIPTION));
        return new RowGeneratorResult(new CatalogPageRow(cpCatalogPageSk, cpCatalogPageId, cpStartDateId, cpEndDateId, cpDepartment, cpCatalogNumber, cpCatalogPageNumber, cpDescription, cpType, nullBitMap));
    }
}

