/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row;

import com.google.common.collect.Lists;
import io.trino.tpcds.generator.CustomerAddressGeneratorColumn;
import io.trino.tpcds.row.TableRowWithNulls;
import io.trino.tpcds.type.Address;
import java.util.List;

public class CustomerAddressRow
extends TableRowWithNulls {
    private final long caAddrSk;
    private final String caAddrId;
    private final Address caAddress;
    private final String caLocationType;

    public CustomerAddressRow(long nullBitMap, long caAddrSk, String caAddrId, Address caAddress, String caLocationType) {
        super(nullBitMap, CustomerAddressGeneratorColumn.CA_ADDRESS_SK);
        this.caAddrSk = caAddrSk;
        this.caAddrId = caAddrId;
        this.caAddress = caAddress;
        this.caLocationType = caLocationType;
    }

    @Override
    public List<String> getValues() {
        return Lists.newArrayList((Object[])new String[]{this.getStringOrNullForKey(this.caAddrSk, CustomerAddressGeneratorColumn.CA_ADDRESS_SK), this.getStringOrNull(this.caAddrId, CustomerAddressGeneratorColumn.CA_ADDRESS_ID), this.getStringOrNull(this.caAddress.getStreetNumber(), CustomerAddressGeneratorColumn.CA_ADDRESS_STREET_NUM), this.getStringOrNull(this.caAddress.getStreetName(), CustomerAddressGeneratorColumn.CA_ADDRESS_STREET_NAME), this.getStringOrNull(this.caAddress.getStreetType(), CustomerAddressGeneratorColumn.CA_ADDRESS_STREET_TYPE), this.getStringOrNull(this.caAddress.getSuiteNumber(), CustomerAddressGeneratorColumn.CA_ADDRESS_SUITE_NUM), this.getStringOrNull(this.caAddress.getCity(), CustomerAddressGeneratorColumn.CA_ADDRESS_CITY), this.getStringOrNull(this.caAddress.getCounty(), CustomerAddressGeneratorColumn.CA_ADDRESS_COUNTY), this.getStringOrNull(this.caAddress.getState(), CustomerAddressGeneratorColumn.CA_ADDRESS_STATE), this.getStringOrNull(String.format("%05d", this.caAddress.getZip()), CustomerAddressGeneratorColumn.CA_ADDRESS_ZIP), this.getStringOrNull(this.caAddress.getCountry(), CustomerAddressGeneratorColumn.CA_ADDRESS_COUNTRY), this.getStringOrNull(this.caAddress.getGmtOffset(), CustomerAddressGeneratorColumn.CA_ADDRESS_GMT_OFFSET), this.getStringOrNull(this.caLocationType, CustomerAddressGeneratorColumn.CA_LOCATION_TYPE)});
    }
}

