/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.random;

import io.trino.tpcds.distribution.CalendarDistribution;
import io.trino.tpcds.distribution.EnglishDistributions;
import io.trino.tpcds.distribution.StringValuesDistribution;
import io.trino.tpcds.distribution.TopDomainsDistribution;
import io.trino.tpcds.random.RandomNumberStream;
import io.trino.tpcds.type.Date;
import io.trino.tpcds.type.Decimal;
import java.util.Objects;

public final class RandomValueGenerator {
    public static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789";
    public static final String DIGITS = "0123456789";

    private RandomValueGenerator() {
    }

    public static int generateUniformRandomInt(int min, int max, RandomNumberStream randomNumberStream) {
        int result = (int)randomNumberStream.nextRandom();
        result %= max - min + 1;
        return result += min;
    }

    public static long generateUniformRandomKey(long min, long max, RandomNumberStream randomNumberStream) {
        int result = (int)randomNumberStream.nextRandom();
        result %= (int)(max - min + 1L);
        return result += (int)min;
    }

    public static Decimal generateUniformRandomDecimal(Decimal min, Decimal max, RandomNumberStream randomNumberStream) {
        int precision = min.getPrecision() < max.getPrecision() ? min.getPrecision() : max.getPrecision();
        long number = randomNumberStream.nextRandom();
        number %= max.getNumber() - min.getNumber() + 1L;
        return new Decimal(number += min.getNumber(), precision);
    }

    public static Date generateUniformRandomDate(Date min, Date max, RandomNumberStream randomNumberStream) {
        int range = Date.toJulianDays(max) - Date.toJulianDays(min);
        int julianDays = Date.toJulianDays(min) + RandomValueGenerator.generateUniformRandomInt(0, range, randomNumberStream);
        return Date.fromJulianDays(julianDays);
    }

    public static Date generateSalesReturnsRandomDate(Date min, Date max, CalendarDistribution.Weights weights, RandomNumberStream randomNumberStream) {
        int dayCount = min.getDay();
        int year = min.getYear();
        int totalWeight = 0;
        int range = Date.toJulianDays(max) - Date.toJulianDays(min);
        for (int i = 0; i < range; ++i) {
            totalWeight += CalendarDistribution.getWeightForDayNumber(dayCount, weights);
            if (dayCount == Date.getDaysInYear(year)) {
                ++year;
                dayCount = 1;
                continue;
            }
            ++dayCount;
        }
        int tempWeightSum = RandomValueGenerator.generateUniformRandomInt(1, totalWeight, randomNumberStream);
        dayCount = min.getDay();
        int julianDays = Date.toJulianDays(min);
        year = min.getYear();
        while (tempWeightSum > 0) {
            tempWeightSum -= CalendarDistribution.getWeightForDayNumber(dayCount, weights);
            ++julianDays;
            if (++dayCount <= Date.getDaysInYear(year)) continue;
            dayCount = 1;
            ++year;
        }
        return Date.fromJulianDays(julianDays);
    }

    public static String generateRandomCharset(String set, int min, int max, RandomNumberStream randomNumberStream) {
        Objects.requireNonNull(set, "set is null");
        int length = RandomValueGenerator.generateUniformRandomInt(min, max, randomNumberStream);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < max; ++i) {
            int index = RandomValueGenerator.generateUniformRandomInt(0, set.length() - 1, randomNumberStream);
            if (i >= length) continue;
            builder.append(set.charAt(index));
        }
        return builder.toString();
    }

    public static String generateRandomEmail(String first, String last, RandomNumberStream randomNumberStream) {
        String domain = TopDomainsDistribution.pickRandomTopDomain(randomNumberStream);
        int companyLength = RandomValueGenerator.generateUniformRandomInt(10, 20, randomNumberStream);
        String company = RandomValueGenerator.generateRandomCharset(ALPHA_NUMERIC, 1, 20, randomNumberStream);
        company = company.length() < companyLength ? company : company.substring(0, companyLength);
        return String.format("%s.%s@%s.%s", first, last, company, domain);
    }

    public static String generateRandomIpAddress(RandomNumberStream randomNumberStream) {
        int[] ipSegments = new int[4];
        for (int i = 0; i < 4; ++i) {
            ipSegments[i] = RandomValueGenerator.generateUniformRandomInt(1, 255, randomNumberStream);
        }
        return String.format("%d.%d.%d.%d", ipSegments[0], ipSegments[1], ipSegments[2], ipSegments[3]);
    }

    public static String generateRandomUrl(RandomNumberStream randomNumberStream) {
        return "http://www.foo.com";
    }

    public static int generateExponentialRandomInt(int min, int max, RandomNumberStream randomNumberStream) {
        int range = max - min + 1;
        double doubleResult = 0.0;
        for (int i = 0; i < 12; ++i) {
            doubleResult += randomNumberStream.nextRandomDouble() - 0.5;
        }
        return min + (int)((double)range * doubleResult);
    }

    public static long generateExponentialRandomKey(long min, long max, RandomNumberStream randomNumberStream) {
        double doubleResult = 0.0;
        for (int i = 0; i < 12; ++i) {
            doubleResult += (double)randomNumberStream.nextRandom() / 2.147483647E9 - 0.5;
        }
        return (int)min + (int)((double)(max - min + 1L) * doubleResult);
    }

    public static Decimal generateExponentialRandomDecimal(Decimal min, Decimal max, Decimal mean, RandomNumberStream randomNumberStream) {
        int precision = min.getPrecision() < max.getPrecision() ? min.getPrecision() : max.getPrecision();
        double doubleResult = 0.0;
        for (int i = 0; i < 12; ++i) {
            doubleResult /= 2.0;
            doubleResult += (double)randomNumberStream.nextRandom() / 2.147483647E9 - 0.5;
        }
        long number = mean.getNumber() + (long)((int)((double)(max.getNumber() - min.getNumber() + 1L) * doubleResult));
        return new Decimal(number, precision);
    }

    public static Date generateExponentialRandomDate(Date min, Date max, RandomNumberStream randomNumberStream) {
        int range = Date.toJulianDays(max) - Date.toJulianDays(min);
        int days = Date.toJulianDays(min) + RandomValueGenerator.generateExponentialRandomInt(0, range, randomNumberStream);
        return Date.fromJulianDays(days);
    }

    public static String generateRandomText(int minLength, int maxLength, RandomNumberStream stream) {
        boolean isSentenceBeginning = true;
        StringBuilder text = new StringBuilder();
        int targetLength = RandomValueGenerator.generateUniformRandomInt(minLength, maxLength, stream);
        while (targetLength > 0) {
            int generatedLength;
            String generated = RandomValueGenerator.generateRandomSentence(stream);
            if (isSentenceBeginning) {
                generated = generated.substring(0, 1).toUpperCase() + generated.substring(1);
            }
            boolean bl = isSentenceBeginning = generated.charAt((generatedLength = generated.length()) - 1) == '.';
            if (targetLength < generatedLength) {
                generated = generated.substring(0, targetLength);
            }
            text.append(generated);
            if ((targetLength -= generatedLength) <= 0) continue;
            text.append(" ");
            --targetLength;
        }
        return text.toString();
    }

    private static String generateRandomSentence(RandomNumberStream stream) {
        StringBuilder verbiage = new StringBuilder();
        String syntax = EnglishDistributions.pickRandomSentence(stream);
        block10: for (int i = 0; i < syntax.length(); ++i) {
            switch (syntax.charAt(i)) {
                case 'N': {
                    verbiage.append(EnglishDistributions.pickRandomNoun(stream));
                    continue block10;
                }
                case 'V': {
                    verbiage.append(EnglishDistributions.pickRandomVerb(stream));
                    continue block10;
                }
                case 'J': {
                    verbiage.append(EnglishDistributions.pickRandomAdjective(stream));
                    continue block10;
                }
                case 'D': {
                    verbiage.append(EnglishDistributions.pickRandomAdverb(stream));
                    continue block10;
                }
                case 'X': {
                    verbiage.append(EnglishDistributions.pickRandomAuxiliary(stream));
                    continue block10;
                }
                case 'P': {
                    verbiage.append(EnglishDistributions.pickRandomPreposition(stream));
                    continue block10;
                }
                case 'A': {
                    verbiage.append(EnglishDistributions.pickRandomArticle(stream));
                    continue block10;
                }
                case 'T': {
                    verbiage.append(EnglishDistributions.pickRandomTerminator(stream));
                    continue block10;
                }
                default: {
                    verbiage.append(syntax.charAt(i));
                }
            }
        }
        return verbiage.toString();
    }

    public static String generateWord(long seed, int maxChars, StringValuesDistribution distribution) {
        long size = distribution.getSize();
        StringBuilder word = new StringBuilder();
        while (seed > 0L) {
            String syllable = distribution.getValueAtIndex(0, (int)(seed % size));
            seed /= size;
            if (word.length() + syllable.length() > maxChars) break;
            word.append(syllable);
        }
        return word.toString();
    }
}

