/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.distribution;

import io.trino.tpcds.distribution.StringValuesDistribution;
import io.trino.tpcds.random.RandomNumberStream;

public final class NamesDistributions {
    private static final StringValuesDistribution FIRST_NAMES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("first_names.dst", 1, 3);
    private static final StringValuesDistribution LAST_NAMES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("last_names.dst", 1, 1);
    private static final StringValuesDistribution SALUTATIONS_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("salutations.dst", 1, 3);

    private NamesDistributions() {
    }

    public static String pickRandomFirstName(FirstNamesWeights firstNamesWeights, RandomNumberStream stream) {
        return FIRST_NAMES_DISTRIBUTION.pickRandomValue(0, firstNamesWeights.ordinal(), stream);
    }

    public static int pickRandomIndex(FirstNamesWeights firstNamesWeights, RandomNumberStream stream) {
        return FIRST_NAMES_DISTRIBUTION.pickRandomIndex(firstNamesWeights.ordinal(), stream);
    }

    public static String getFirstNameFromIndex(int index) {
        return FIRST_NAMES_DISTRIBUTION.getValueAtIndex(0, index);
    }

    public static int getWeightForIndex(int index, FirstNamesWeights firstNamesWeights) {
        return FIRST_NAMES_DISTRIBUTION.getWeightForIndex(index, firstNamesWeights.ordinal());
    }

    public static String pickRandomLastName(RandomNumberStream stream) {
        return LAST_NAMES_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomSalutation(SalutationsWeights salutationsWeights, RandomNumberStream stream) {
        return SALUTATIONS_DISTRIBUTION.pickRandomValue(0, salutationsWeights.ordinal(), stream);
    }

    public static enum SalutationsWeights {
        GENDER_NEUTRAL,
        MALE,
        FEMALE;

    }

    public static enum FirstNamesWeights {
        MALE_FREQUENCY,
        FEMALE_FREQUENCY,
        GENERAL_FREQUENCY;

    }
}

