/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.Scaling;
import io.trino.tpcds.Table;
import io.trino.tpcds.TpcdsException;
import io.trino.tpcds.type.Date;

public final class SlowlyChangingDimensionUtils {
    private static final long ONE_HALF_DATE = Date.JULIAN_DATA_START_DATE + (Date.JULIAN_DATA_END_DATE - Date.JULIAN_DATA_START_DATE) / 2;
    private static final long ONE_THIRD_PERIOD = (Date.JULIAN_DATA_END_DATE - Date.JULIAN_DATA_START_DATE) / 3;
    private static final long ONE_THIRD_DATE = (long)Date.JULIAN_DATA_START_DATE + ONE_THIRD_PERIOD;
    private static final long TWO_THIRDS_DATE = ONE_THIRD_DATE + ONE_THIRD_PERIOD;

    private SlowlyChangingDimensionUtils() {
    }

    public static SlowlyChangingDimensionKey computeScdKey(Table table, long rowNumber) {
        long endDate;
        long startDate;
        String businessKey;
        int modulo = (int)rowNumber % 6;
        boolean isNewKey = false;
        int tableNumber = table.ordinal();
        switch (modulo) {
            case 1: {
                businessKey = BusinessKeyGenerator.makeBusinessKey(rowNumber);
                isNewKey = true;
                startDate = Date.JULIAN_DATA_START_DATE - tableNumber * 6;
                endDate = -1L;
                break;
            }
            case 2: {
                businessKey = BusinessKeyGenerator.makeBusinessKey(rowNumber);
                isNewKey = true;
                startDate = Date.JULIAN_DATA_START_DATE - tableNumber * 6;
                endDate = ONE_HALF_DATE - (long)(tableNumber * 6);
                break;
            }
            case 3: {
                businessKey = BusinessKeyGenerator.makeBusinessKey(rowNumber - 1L);
                startDate = ONE_HALF_DATE - (long)(tableNumber * 6) + 1L;
                endDate = -1L;
                break;
            }
            case 4: {
                businessKey = BusinessKeyGenerator.makeBusinessKey(rowNumber);
                isNewKey = true;
                startDate = Date.JULIAN_DATA_START_DATE - tableNumber * 6;
                endDate = ONE_THIRD_DATE - (long)(tableNumber * 6);
                break;
            }
            case 5: {
                businessKey = BusinessKeyGenerator.makeBusinessKey(rowNumber - 1L);
                startDate = ONE_THIRD_DATE - (long)(tableNumber * 6) + 1L;
                endDate = TWO_THIRDS_DATE - (long)(tableNumber * 6);
                break;
            }
            case 0: {
                businessKey = BusinessKeyGenerator.makeBusinessKey(rowNumber - 2L);
                startDate = TWO_THIRDS_DATE - (long)(tableNumber * 6) + 1L;
                endDate = -1L;
                break;
            }
            default: {
                throw new InternalError("Something's wrong. Positive integers % 6 should always be covered by one of the cases");
            }
        }
        if (endDate > (long)Date.JULIAN_DATA_END_DATE) {
            endDate = -1L;
        }
        return new SlowlyChangingDimensionKey(businessKey, startDate, endDate, isNewKey);
    }

    public static <T> T getValueForSlowlyChangingDimension(int fieldChangeFlag, boolean isNewKey, T oldValue, T newValue) {
        return SlowlyChangingDimensionUtils.shouldChangeDimension(fieldChangeFlag, isNewKey) ? newValue : oldValue;
    }

    public static boolean shouldChangeDimension(int flags, boolean isNewKey) {
        return flags % 2 == 0 || isNewKey;
    }

    public static long matchSurrogateKey(long unique, long julianDate, Table table, Scaling scaling) {
        long surrogateKey = unique / 3L * 6L;
        switch ((int)(unique % 3L)) {
            case 1: {
                ++surrogateKey;
                break;
            }
            case 2: {
                surrogateKey += 2L;
                if (julianDate <= ONE_HALF_DATE) break;
                ++surrogateKey;
                break;
            }
            case 0: {
                surrogateKey -= 2L;
                if (julianDate > ONE_THIRD_DATE) {
                    ++surrogateKey;
                }
                if (julianDate <= TWO_THIRDS_DATE) break;
                ++surrogateKey;
                break;
            }
            default: {
                throw new TpcdsException("unique % 3 did not equal 0, 1, or 2");
            }
        }
        if (surrogateKey > scaling.getRowCount(table)) {
            surrogateKey = scaling.getRowCount(table);
        }
        return surrogateKey;
    }

    public static class SlowlyChangingDimensionKey {
        private final String businessKey;
        private final long startDate;
        private final long endDate;
        private final boolean isNewBusinessKey;

        public SlowlyChangingDimensionKey(String businessKey, long startDate, long endDate, boolean isNewBusinessKey) {
            this.businessKey = businessKey;
            this.startDate = startDate;
            this.endDate = endDate;
            this.isNewBusinessKey = isNewBusinessKey;
        }

        public String getBusinessKey() {
            return this.businessKey;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public long getEndDate() {
            return this.endDate;
        }

        public boolean isNewBusinessKey() {
            return this.isNewBusinessKey;
        }
    }
}

