/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import com.google.common.base.Preconditions;
import io.trino.tpcds.Scaling;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.type.Date;

public final class Parallel {
    private Parallel() {
    }

    public static ChunkBoundaries splitWork(Table table, Session session) {
        long totalRows = session.getScaling().getRowCount(table);
        int chunk = session.getChunkNumber();
        if (totalRows < 1000000L) {
            if (chunk > 1) {
                return new ChunkBoundaries(1L, 0L);
            }
            return new ChunkBoundaries(1L, totalRows);
        }
        int parallelism = session.getParallelism();
        long extraRows = totalRows % (long)parallelism;
        long rowSetSize = totalRows / (long)parallelism;
        long firstRowOfChunk = 1L;
        firstRowOfChunk += (long)(chunk - 1) * rowSetSize;
        if (extraRows != 0L && chunk - 1 != 0) {
            firstRowOfChunk += (long)(chunk - 1) < extraRows ? (long)(chunk - 1) : extraRows;
        }
        long rowCount = rowSetSize;
        if (extraRows != 0L && (long)chunk <= extraRows) {
            ++rowCount;
        }
        return new ChunkBoundaries(firstRowOfChunk, firstRowOfChunk + rowCount - 1L);
    }

    public static DateNextIndexPair skipDaysUntilFirstRowOfChunk(Table table, Session session) {
        long julianDate = Date.JULIAN_DATA_START_DATE;
        Scaling scaling = session.getScaling();
        long index = 1L;
        long newDateIndex = scaling.getRowCountForDate(table, julianDate) + index;
        ChunkBoundaries boundary = Parallel.splitWork(table, session);
        while (index < boundary.getFirstRow()) {
            newDateIndex = index += scaling.getRowCountForDate(table, ++julianDate);
        }
        if (index > boundary.getFirstRow()) {
            --julianDate;
        }
        return new DateNextIndexPair(julianDate, newDateIndex);
    }

    public static final class DateNextIndexPair {
        private final long julianDate;
        private final long nextDateIndex;

        public DateNextIndexPair(long julianDate, long nextDateIndex) {
            this.julianDate = julianDate;
            this.nextDateIndex = nextDateIndex;
        }

        public long getJulianDate() {
            return this.julianDate;
        }

        public long getNextDateIndex() {
            return this.nextDateIndex;
        }
    }

    public static class ChunkBoundaries {
        private final long firstRow;
        private final long lastRow;

        private ChunkBoundaries(long firstRow, long lastRow) {
            Preconditions.checkArgument((firstRow >= 0L ? 1 : 0) != 0, (Object)"firstRow is negative");
            Preconditions.checkArgument((lastRow >= 0L ? 1 : 0) != 0, (Object)"lastRow is negative");
            this.firstRow = firstRow;
            this.lastRow = lastRow;
        }

        public long getFirstRow() {
            return this.firstRow;
        }

        public long getLastRow() {
            return this.lastRow;
        }
    }
}

