/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.datatypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftBigint;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftColumnData;
import io.trino.plugin.thrift.api.datatypes.TrinoThriftTypeUtils;
import io.trino.spi.block.AbstractArrayBlock;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@ThriftStruct
public final class TrinoThriftBigintArray
implements TrinoThriftColumnData {
    private final boolean[] nulls;
    private final int[] sizes;
    private final TrinoThriftBigint values;

    @ThriftConstructor
    public TrinoThriftBigintArray(@ThriftField(name="nulls") @Nullable boolean[] nulls, @ThriftField(name="sizes") @Nullable int[] sizes, @ThriftField(name="values") @Nullable TrinoThriftBigint values) {
        Preconditions.checkArgument((boolean)TrinoThriftTypeUtils.sameSizeIfPresent(nulls, sizes), (Object)"nulls and values must be of the same size");
        Preconditions.checkArgument((TrinoThriftTypeUtils.totalSize(nulls, sizes) == TrinoThriftBigintArray.numberOfValues(values) ? 1 : 0) != 0, (Object)"total number of values doesn't match expected size");
        this.nulls = nulls;
        this.sizes = sizes;
        this.values = values;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public boolean[] getNulls() {
        return this.nulls;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public int[] getSizes() {
        return this.sizes;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftBigint getValues() {
        return this.values;
    }

    @Override
    public Block toBlock(Type desiredType) {
        Preconditions.checkArgument((desiredType.getTypeParameters().size() == 1 && BigintType.BIGINT.equals(desiredType.getTypeParameters().get(0)) ? 1 : 0) != 0, (String)"type doesn't match: %s", (Object)desiredType);
        int numberOfRecords = this.numberOfRecords();
        return ArrayBlock.fromElementBlock((int)numberOfRecords, Optional.of(this.nulls == null ? new boolean[numberOfRecords] : this.nulls), (int[])TrinoThriftTypeUtils.calculateOffsets(this.sizes, this.nulls, numberOfRecords), (Block)(this.values != null ? this.values.toBlock((Type)BigintType.BIGINT) : new LongArrayBlock(0, Optional.empty(), new long[0])));
    }

    @Override
    public int numberOfRecords() {
        if (this.nulls != null) {
            return this.nulls.length;
        }
        if (this.sizes != null) {
            return this.sizes.length;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftBigintArray other = (TrinoThriftBigintArray)obj;
        return Arrays.equals(this.nulls, other.nulls) && Arrays.equals(this.sizes, other.sizes) && Objects.equals(this.values, other.values);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.nulls), Arrays.hashCode(this.sizes), this.values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRecords", this.numberOfRecords()).toString();
    }

    public static TrinoThriftBlock fromBlock(Block block) {
        int positions = block.getPositionCount();
        if (positions == 0) {
            return TrinoThriftBlock.bigintArrayData(new TrinoThriftBigintArray(null, null, null));
        }
        if (block instanceof RunLengthEncodedBlock && block.isNull(0)) {
            boolean[] nulls = new boolean[positions];
            Arrays.fill(nulls, true);
            return TrinoThriftBlock.bigintArrayData(new TrinoThriftBigintArray(nulls, null, null));
        }
        Preconditions.checkArgument((boolean)(block instanceof AbstractArrayBlock), (Object)"block is not of an array type");
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        boolean[] nulls = null;
        int[] sizes = null;
        for (int position = 0; position < positions; ++position) {
            if (arrayBlock.isNull(position)) {
                if (nulls == null) {
                    nulls = new boolean[positions];
                }
                nulls[position] = true;
                continue;
            }
            if (sizes == null) {
                sizes = new int[positions];
            }
            sizes[position] = (Integer)arrayBlock.apply((valuesBlock, startPosition, length) -> length, position);
        }
        TrinoThriftBigint values = ((TrinoThriftBlock)arrayBlock.apply((valuesBlock, startPosition, length) -> TrinoThriftBigint.fromBlock(valuesBlock), 0)).getBigintData();
        Preconditions.checkState((values != null ? 1 : 0) != 0, (Object)"values must be present");
        Preconditions.checkState((TrinoThriftTypeUtils.totalSize(nulls, sizes) == values.numberOfRecords() ? 1 : 0) != 0, (Object)"unexpected number of values");
        return TrinoThriftBlock.bigintArrayData(new TrinoThriftBigintArray(nulls, sizes, values));
    }

    private static int numberOfValues(TrinoThriftBigint values) {
        return values != null ? values.numberOfRecords() : 0;
    }
}

