/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class MemoizingSupplier<T>
implements Supplier<T> {
    private final Supplier<T> create;
    private Supplier<T> delegate = this::init;
    private volatile boolean initialized;
    private T value;

    private MemoizingSupplier(Supplier<T> create) {
        this.create = create;
    }

    public static <T> MemoizingSupplier<T> of(Supplier<T> supplier) {
        return new MemoizingSupplier<T>(supplier);
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    private T internalGet() {
        return this.value;
    }

    public void ifInitialized(Consumer<T> consumer) {
        if (this.initialized) {
            consumer.accept(this.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T init() {
        MemoizingSupplier memoizingSupplier = this;
        synchronized (memoizingSupplier) {
            if (!this.initialized) {
                this.value = this.create.get();
                this.initialized = true;
                this.delegate = this::internalGet;
            }
            return this.delegate.get();
        }
    }
}

