/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Preconditions;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import java.util.Map;

public class DefaultSystemAccessControl
extends AllowAllSystemAccessControl {
    public static final String NAME = "default";
    private static final DefaultSystemAccessControl INSTANCE = new DefaultSystemAccessControl();

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
    }

    @Override
    public void checkCanWriteSystemInformation(Identity identity) {
        AccessDeniedException.denyWriteSystemInformationAccess();
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return DefaultSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Preconditions.checkArgument((boolean)config.isEmpty(), (Object)"This access controller does not support any configuration properties");
            return INSTANCE;
        }
    }
}

