/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.network.ClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;
import javax.annotation.Nullable;

public final class InternalClientAttributesExtractor<REQUEST, RESPONSE> {
    private final ClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final FallbackAddressPortExtractor<REQUEST> fallbackAddressPortExtractor;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalClientAttributesExtractor(ClientAttributesGetter<REQUEST, RESPONSE> getter, FallbackAddressPortExtractor<REQUEST> fallbackAddressPortExtractor, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.fallbackAddressPortExtractor = fallbackAddressPortExtractor;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort clientAddressAndPort = this.extractClientAddressAndPort(request);
        if (this.emitStableUrlAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.CLIENT_ADDRESS, (Object)clientAddressAndPort.address);
            if (clientAddressAndPort.port != null && clientAddressAndPort.port > 0) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.CLIENT_PORT, (Object)clientAddressAndPort.port);
            }
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_CLIENT_IP, (Object)clientAddressAndPort.address);
        }
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        AddressAndPort clientAddressAndPort = this.extractClientAddressAndPort(request);
        String clientSocketAddress = this.getter.getClientSocketAddress(request, response);
        Integer clientSocketPort = this.getter.getClientSocketPort(request, response);
        if (clientSocketAddress != null && !clientSocketAddress.equals(clientAddressAndPort.address)) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.CLIENT_SOCKET_ADDRESS, (Object)clientSocketAddress);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)clientSocketAddress);
            }
        }
        if (clientSocketPort != null && clientSocketPort > 0) {
            if (this.emitStableUrlAttributes && !clientSocketPort.equals(clientAddressAndPort.port)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.CLIENT_SOCKET_PORT, (Object)clientSocketPort);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_PEER_PORT, (Object)clientSocketPort);
            }
        }
    }

    private AddressAndPort extractClientAddressAndPort(REQUEST request) {
        AddressAndPort addressAndPort = new AddressAndPort();
        addressAndPort.address = this.getter.getClientAddress(request);
        addressAndPort.port = this.getter.getClientPort(request);
        if (addressAndPort.address == null && addressAndPort.port == null) {
            this.fallbackAddressPortExtractor.extract(addressAndPort, request);
        }
        return addressAndPort;
    }
}

