/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMetricsAdvice;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMetricsUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class HttpServerMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_SERVER_METRICS_STATE = ContextKey.named((String)"http-server-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpServerMetrics.class.getName());
    @Nullable
    private final DoubleHistogram stableDuration;
    @Nullable
    private final DoubleHistogram oldDuration;

    public static OperationMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        if (SemconvStability.emitStableHttpSemconv()) {
            DoubleHistogramBuilder stableDurationBuilder = HttpMetricsUtil.createStableDurationHistogramBuilder(meter, "http.server.request.duration", "The duration of the inbound HTTP request");
            HttpMetricsAdvice.applyStableServerDurationAdvice(stableDurationBuilder);
            this.stableDuration = stableDurationBuilder.build();
        } else {
            this.stableDuration = null;
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            DoubleHistogramBuilder oldDurationBuilder = meter.histogramBuilder("http.server.duration").setUnit("ms").setDescription("The duration of the inbound HTTP request");
            HttpMetricsAdvice.applyOldServerDurationAdvice(oldDurationBuilder);
            this.oldDuration = oldDurationBuilder.build();
        } else {
            this.oldDuration = null;
        }
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_SERVER_METRICS_STATE, (Object)new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = (State)context.get(HTTP_SERVER_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        if (this.stableDuration != null) {
            this.stableDuration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
        }
        if (this.oldDuration != null) {
            this.oldDuration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, attributes, context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

