/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.inject.Inject;
import io.trino.plugin.jdbc.DynamicFilteringJdbcSplitSource;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSessionProperties;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import java.util.Objects;

public class JdbcSplitManager
implements ConnectorSplitManager {
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcSplitManager(JdbcClient jdbcClient) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        if (table instanceof JdbcProcedureHandle) {
            JdbcProcedureHandle procedureHandle = (JdbcProcedureHandle)table;
            return this.jdbcClient.getSplits(session, procedureHandle);
        }
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        ConnectorSplitSource jdbcSplitSource = this.jdbcClient.getSplits(session, tableHandle);
        if (JdbcDynamicFilteringSessionProperties.dynamicFilteringEnabled(session)) {
            return new DynamicFilteringJdbcSplitSource(jdbcSplitSource, dynamicFilter, tableHandle);
        }
        return jdbcSplitSource;
    }
}

