/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import jakarta.validation.constraints.Min;

@DefunctConfig(value={"allow-drop-table"})
public class JdbcMetadataConfig {
    private boolean complexExpressionPushdownEnabled = true;
    private boolean joinPushdownEnabled;
    private boolean aggregationPushdownEnabled = true;
    private boolean topNPushdownEnabled = true;
    private int domainCompactionThreshold = 32;

    public boolean isComplexExpressionPushdownEnabled() {
        return this.complexExpressionPushdownEnabled;
    }

    @Config(value="complex-expression-pushdown.enabled")
    public JdbcMetadataConfig setComplexExpressionPushdownEnabled(boolean complexExpressionPushdownEnabled) {
        this.complexExpressionPushdownEnabled = complexExpressionPushdownEnabled;
        return this;
    }

    public boolean isJoinPushdownEnabled() {
        return this.joinPushdownEnabled;
    }

    @LegacyConfig(value={"experimental.join-pushdown.enabled"})
    @Config(value="join-pushdown.enabled")
    @ConfigDescription(value="Enable join pushdown")
    public JdbcMetadataConfig setJoinPushdownEnabled(boolean joinPushdownEnabled) {
        this.joinPushdownEnabled = joinPushdownEnabled;
        return this;
    }

    public boolean isAggregationPushdownEnabled() {
        return this.aggregationPushdownEnabled;
    }

    @Config(value="aggregation-pushdown.enabled")
    @LegacyConfig(value={"allow-aggregation-pushdown"})
    @ConfigDescription(value="Enable aggregation pushdown")
    public JdbcMetadataConfig setAggregationPushdownEnabled(boolean aggregationPushdownEnabled) {
        this.aggregationPushdownEnabled = aggregationPushdownEnabled;
        return this;
    }

    @Config(value="topn-pushdown.enabled")
    @ConfigDescription(value="Enable TopN pushdown")
    public JdbcMetadataConfig setTopNPushdownEnabled(boolean enabled) {
        this.topNPushdownEnabled = enabled;
        return this;
    }

    public Boolean isTopNPushdownEnabled() {
        return this.topNPushdownEnabled;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public JdbcMetadataConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }
}

