/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdbi.v3.core.CloseException;
import org.jdbi.v3.core.ConstantHandleSupplier;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.HandleConsumer;
import org.jdbi.v3.core.HandleListener;
import org.jdbi.v3.core.Handles;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.TransactionCallback;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.Configurable;
import org.jdbi.v3.core.extension.ExtensionContext;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.NoSuchExtensionException;
import org.jdbi.v3.core.internal.exceptions.ThrowableSuppressor;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.Call;
import org.jdbi.v3.core.statement.Cleanable;
import org.jdbi.v3.core.statement.MetaData;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Script;
import org.jdbi.v3.core.statement.StatementBuilder;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionHandler;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.core.transaction.UnableToManipulateTransactionIsolationLevelException;
import org.jdbi.v3.meta.Beta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handle
implements Closeable,
Configurable<Handle> {
    private static final Logger LOG = LoggerFactory.getLogger(Handle.class);
    private final Jdbi jdbi;
    private final Cleanable connectionCleaner;
    private final TransactionHandler transactionHandler;
    private final Connection connection;
    private final boolean forceEndTransactions;
    private StatementBuilder statementBuilder;
    private final ExtensionContext defaultExtensionContext;
    private ExtensionContext currentExtensionContext;
    @GuardedBy(value="transactionCallbacks")
    private final List<TransactionCallback> transactionCallbacks = new ArrayList<TransactionCallback>();
    private final Set<Cleanable> cleanables = new LinkedHashSet<Cleanable>();
    private final Set<HandleListener> handleListeners;
    private final AtomicBoolean closed = new AtomicBoolean();

    static Handle createHandle(Jdbi jdbi, Cleanable connectionCleaner, TransactionHandler transactionHandler, StatementBuilder statementBuilder, Connection connection) throws SQLException {
        Handle handle = new Handle(jdbi, connectionCleaner, transactionHandler, statementBuilder, connection);
        handle.notifyHandleCreated();
        return handle;
    }

    private Handle(Jdbi jdbi, Cleanable connectionCleaner, TransactionHandler transactionHandler, StatementBuilder statementBuilder, Connection connection) throws SQLException {
        this.jdbi = jdbi;
        this.connectionCleaner = connectionCleaner;
        this.connection = connection;
        this.currentExtensionContext = this.defaultExtensionContext = ExtensionContext.forConfig(jdbi.getConfig().createCopy());
        this.statementBuilder = statementBuilder;
        this.handleListeners = this.getConfig().get(Handles.class).copyListeners();
        this.transactionHandler = transactionHandler.specialize(this);
        this.forceEndTransactions = !transactionHandler.isInTransaction(this);
        this.addCleanable(() -> {
            if (this.checkConnectionIsLive()) {
                statementBuilder.close(connection);
            }
        });
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    @Override
    public ConfigRegistry getConfig() {
        return this.currentExtensionContext.getConfig();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public StatementBuilder getStatementBuilder() {
        return this.statementBuilder;
    }

    public Handle setStatementBuilder(StatementBuilder builder) {
        this.statementBuilder = builder;
        return this;
    }

    public Handle addHandleListener(HandleListener handleListener) {
        this.handleListeners.add(handleListener);
        return this;
    }

    public Handle removeHandleListener(HandleListener handleListener) {
        this.handleListeners.remove(handleListener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCleanable(Cleanable cleanable) {
        Set<Cleanable> set = this.cleanables;
        synchronized (set) {
            this.cleanables.add(cleanable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCleanable(Cleanable cleanable) {
        Set<Cleanable> set = this.cleanables;
        synchronized (set) {
            this.cleanables.remove(cleanable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        boolean doForceEndTransactions = this.forceEndTransactions && this.getConfig().get(Handles.class).isForceEndTransactions();
        try {
            ThrowableSuppressor throwableSuppressor = new ThrowableSuppressor();
            this.doClean(throwableSuppressor);
            try {
                this.cleanConnection(doForceEndTransactions);
            }
            catch (Throwable t2) {
                throwableSuppressor.attachToThrowable(t2);
                throw t2;
            }
            throwableSuppressor.throwIfNecessary(t -> new CloseException("While closing handle", (Throwable)t));
        }
        finally {
            LOG.trace("Handle [{}] released", (Object)this);
            this.notifyHandleClosed();
        }
    }

    public void clean() {
        ThrowableSuppressor throwableSuppressor = new ThrowableSuppressor();
        this.doClean(throwableSuppressor);
        throwableSuppressor.throwIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClean() {
        Set<Cleanable> set = this.cleanables;
        synchronized (set) {
            return this.cleanables.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClean(ThrowableSuppressor throwableSuppressor) {
        ArrayList<Cleanable> cleanablesCopy;
        Set<Cleanable> set = this.cleanables;
        synchronized (set) {
            cleanablesCopy = new ArrayList<Cleanable>(this.cleanables);
            this.cleanables.clear();
        }
        Collections.reverse(cleanablesCopy);
        for (Cleanable cleanable : cleanablesCopy) {
            throwableSuppressor.suppressAppend(cleanable::close);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public Query select(CharSequence sql, Object ... args) {
        Query query = this.createQuery(sql);
        int position = 0;
        for (Object arg : args) {
            query.bind(position++, arg);
        }
        return query;
    }

    public Query select(String sql, Object ... args) {
        return this.select((CharSequence)sql, args);
    }

    public int execute(CharSequence sql, Object ... args) {
        try (Update stmt = this.createUpdate(sql);){
            int position = 0;
            for (Object arg : args) {
                stmt.bind(position++, arg);
            }
            int n = stmt.execute();
            return n;
        }
    }

    public int execute(String sql, Object ... args) {
        return this.execute((CharSequence)sql, args);
    }

    public Batch createBatch() {
        return new Batch(this);
    }

    public PreparedBatch prepareBatch(CharSequence sql) {
        return new PreparedBatch(this, sql);
    }

    public PreparedBatch prepareBatch(String sql) {
        return this.prepareBatch((CharSequence)sql);
    }

    public Call createCall(CharSequence sql) {
        return new Call(this, sql);
    }

    public Call createCall(String sql) {
        return this.createCall((CharSequence)sql);
    }

    public Query createQuery(CharSequence sql) {
        return new Query(this, sql);
    }

    public Query createQuery(String sql) {
        return this.createQuery((CharSequence)sql);
    }

    public Script createScript(CharSequence sql) {
        return new Script(this, sql);
    }

    public Script createScript(String sql) {
        return this.createScript((CharSequence)sql);
    }

    public Update createUpdate(CharSequence sql) {
        return new Update(this, sql);
    }

    public Update createUpdate(String sql) {
        return this.createUpdate((CharSequence)sql);
    }

    public ResultBearing queryMetadata(MetaData.MetaDataResultSetProvider metadataFunction) {
        return new MetaData(this, metadataFunction);
    }

    public <T> T queryMetadata(MetaData.MetaDataValueProvider<T> metadataFunction) {
        try (MetaData metadata = new MetaData(this, metadataFunction);){
            Object r = metadata.execute();
            return (T)r;
        }
    }

    public boolean isInTransaction() {
        return this.transactionHandler.isInTransaction(this);
    }

    public Handle begin() {
        this.transactionHandler.begin(this);
        LOG.trace("Handle [{}] begin transaction", (Object)this);
        return this;
    }

    public Handle commit() {
        long start = System.nanoTime();
        this.transactionHandler.commit(this);
        LOG.trace("Handle [{}] commit transaction in {}ms", (Object)this, (Object)Handle.msSince(start));
        this.drainCallbacks().forEach(TransactionCallback::afterCommit);
        return this;
    }

    public Handle rollback() {
        long start = System.nanoTime();
        this.transactionHandler.rollback(this);
        LOG.trace("Handle [{}] rollback transaction in {}ms", (Object)this, (Object)Handle.msSince(start));
        this.drainCallbacks().forEach(TransactionCallback::afterRollback);
        return this;
    }

    @Beta
    public Handle afterCommit(final Runnable afterCommit) {
        return this.addTransactionCallback(new TransactionCallback(){

            @Override
            public void afterCommit() {
                afterCommit.run();
            }
        });
    }

    @Beta
    public Handle afterRollback(final Runnable afterRollback) {
        return this.addTransactionCallback(new TransactionCallback(){

            @Override
            public void afterRollback() {
                afterRollback.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TransactionCallback> drainCallbacks() {
        List<TransactionCallback> list = this.transactionCallbacks;
        synchronized (list) {
            ArrayList<TransactionCallback> result = new ArrayList<TransactionCallback>(this.transactionCallbacks);
            this.transactionCallbacks.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handle addTransactionCallback(TransactionCallback cb) {
        if (!this.isInTransaction()) {
            throw new IllegalStateException("Handle must be in transaction");
        }
        List<TransactionCallback> list = this.transactionCallbacks;
        synchronized (list) {
            this.transactionCallbacks.add(cb);
        }
        return this;
    }

    public Handle rollbackToSavepoint(String savepointName) {
        long start = System.nanoTime();
        this.transactionHandler.rollbackToSavepoint(this, savepointName);
        LOG.trace("Handle [{}] rollback to savepoint \"{}\" in {}ms", new Object[]{this, savepointName, Handle.msSince(start)});
        return this;
    }

    private static long msSince(long start) {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }

    public Handle savepoint(String name) {
        this.transactionHandler.savepoint(this, name);
        LOG.trace("Handle [{}] savepoint \"{}\"", (Object)this, (Object)name);
        return this;
    }

    @Deprecated
    public Handle release(String savepointName) {
        return this.releaseSavepoint(savepointName);
    }

    public Handle releaseSavepoint(String savepointName) {
        this.transactionHandler.releaseSavepoint(this, savepointName);
        LOG.trace("Handle [{}] release savepoint \"{}\"", (Object)this, (Object)savepointName);
        return this;
    }

    public boolean isReadOnly() {
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not get read-only status for a connection", e);
        }
    }

    public Handle setReadOnly(boolean readOnly) {
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("Could not setReadOnly", e);
        }
        return this;
    }

    public <R, X extends Exception> R inTransaction(HandleCallback<R, X> callback) throws X {
        return this.isInTransaction() ? callback.withHandle(this) : this.transactionHandler.inTransaction(this, callback);
    }

    public <X extends Exception> void useTransaction(HandleConsumer<X> consumer) throws X {
        this.inTransaction(consumer.asCallback());
    }

    public <R, X extends Exception> R inTransaction(TransactionIsolationLevel level, HandleCallback<R, X> callback) throws X {
        if (this.isInTransaction()) {
            TransactionIsolationLevel currentLevel = this.getTransactionIsolationLevel();
            if (currentLevel != level && level != TransactionIsolationLevel.UNKNOWN) {
                throw new TransactionException("Tried to execute nested transaction with isolation level " + String.valueOf((Object)level) + ", but already running in a transaction with isolation level " + String.valueOf((Object)currentLevel) + ".");
            }
            return callback.withHandle(this);
        }
        try (SetTransactionIsolation isolation = new SetTransactionIsolation(level);){
            R r = this.transactionHandler.inTransaction(this, level, callback);
            return r;
        }
    }

    public <X extends Exception> void useTransaction(TransactionIsolationLevel level, HandleConsumer<X> consumer) throws X {
        this.inTransaction(level, consumer.asCallback());
    }

    @Deprecated
    public void setTransactionIsolation(TransactionIsolationLevel level) {
        this.setTransactionIsolationLevel(level);
    }

    public void setTransactionIsolationLevel(TransactionIsolationLevel level) {
        if (level != TransactionIsolationLevel.UNKNOWN) {
            this.setTransactionIsolationLevel(level.intValue());
        }
    }

    @Deprecated
    public void setTransactionIsolation(int level) {
        this.setTransactionIsolationLevel(level);
    }

    public void setTransactionIsolationLevel(int level) {
        try {
            if (this.connection.getTransactionIsolation() != level) {
                this.connection.setTransactionIsolation(level);
            }
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException(level, e);
        }
    }

    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            return TransactionIsolationLevel.valueOf(this.connection.getTransactionIsolation());
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("unable to access current setting", e);
        }
    }

    public <T> T attach(Class<T> extensionType) {
        return this.getConfig(Extensions.class).findFor(extensionType, ConstantHandleSupplier.of(this)).orElseThrow(() -> new NoSuchExtensionException(extensionType));
    }

    public ExtensionMethod getExtensionMethod() {
        return this.currentExtensionContext.getExtensionMethod();
    }

    Handle acceptExtensionContext(ExtensionContext extensionContext) {
        this.currentExtensionContext = extensionContext == null ? this.defaultExtensionContext : extensionContext;
        return this;
    }

    private void notifyHandleCreated() {
        this.handleListeners.forEach(listener -> listener.handleCreated(this));
    }

    private void notifyHandleClosed() {
        this.handleListeners.forEach(listener -> listener.handleClosed(this));
    }

    private void cleanConnection(boolean doForceEndTransactions) {
        ThrowableSuppressor throwableSuppressor = new ThrowableSuppressor();
        boolean connectionIsLive = this.checkConnectionIsLive();
        boolean wasInTransaction = false;
        if (connectionIsLive && doForceEndTransactions) {
            wasInTransaction = throwableSuppressor.suppressAppend(this::isInTransaction, false);
        }
        if (wasInTransaction) {
            throwableSuppressor.suppressAppend(this::rollback);
        }
        if (connectionIsLive) {
            try {
                this.connectionCleaner.close();
            }
            catch (SQLException e) {
                CloseException ce = new CloseException("Unable to close Connection", e);
                throwableSuppressor.attachToThrowable(ce);
                throw ce;
            }
            throwableSuppressor.throwIfNecessary(t -> new CloseException("Failed to clear transaction status on close", (Throwable)t));
            if (wasInTransaction) {
                TransactionException te = new TransactionException("Improper transaction handling detected: A Handle with an open transaction was closed. Transactions must be explicitly committed or rolled back before closing the Handle. Jdbi has rolled back this transaction automatically. This check may be disabled by calling getConfig(Handles.class).setForceEndTransactions(false).");
                throwableSuppressor.attachToThrowable(te);
                throw te;
            }
        } else {
            throwableSuppressor.throwIfNecessary(t -> new CloseException("Failed to clear transaction status on close", (Throwable)t));
        }
    }

    private boolean checkConnectionIsLive() {
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Handle handle = (Handle)o;
        return this.jdbi.equals(handle.jdbi) && this.connection.equals(handle.connection);
    }

    public int hashCode() {
        return Objects.hash(this.jdbi, this.connection);
    }

    class SetTransactionIsolation
    implements AutoCloseable {
        private final TransactionIsolationLevel prevLevel;

        SetTransactionIsolation(TransactionIsolationLevel setLevel) {
            this.prevLevel = Handle.this.getTransactionIsolationLevel();
            Handle.this.setTransactionIsolationLevel(setLevel);
        }

        @Override
        public void close() {
            Handle.this.setTransactionIsolationLevel(this.prevLevel);
        }
    }
}

