/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.TypePattern;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Objects;
import java.util.Optional;

public class ExpressionCapture
extends ExpressionPattern {
    private final String name;
    private final Optional<TypePattern> type;
    private final Capture<ConnectorExpression> capture = Capture.newCapture();
    private final Pattern<ConnectorExpression> pattern;

    public ExpressionCapture(String name) {
        this(name, Optional.empty());
    }

    public ExpressionCapture(String name, TypePattern type) {
        this(name, Optional.of(type));
    }

    public ExpressionCapture(String name, Optional<TypePattern> type) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        Pattern pattern = Pattern.typeOf(ConnectorExpression.class).capturedAs(this.capture);
        if (type.isPresent()) {
            pattern = pattern.with(ConnectorExpressionPatterns.type().matching(type.get().getPattern()));
        }
        this.pattern = pattern;
    }

    public Pattern<ConnectorExpression> getPattern() {
        return this.pattern;
    }

    @Override
    public void resolve(Captures captures, MatchContext matchContext) {
        matchContext.record(this.name, captures.get(this.capture));
        this.type.ifPresent(type -> type.resolve(captures, matchContext));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCapture that = (ExpressionCapture)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Override
    public String toString() {
        if (this.type.isEmpty()) {
            return this.name;
        }
        return String.format("%s: %s", this.name, this.type.get());
    }
}

