/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.CheckedCallable;
import org.jdbi.v3.core.internal.exceptions.Sneaky;

public final class JdbiClassUtils {
    private static final Object[] NO_ARGS = new Object[0];

    private JdbiClassUtils() {
        throw new UtilityClassException();
    }

    public static boolean isPresent(String klass) {
        try {
            Class.forName(klass);
            return true;
        }
        catch (ReflectiveOperationException ignored) {
            return false;
        }
    }

    public static Method methodLookup(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(methodName, parameterTypes);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            try {
                return klass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (ReflectiveOperationException | SecurityException e2) {
                e.addSuppressed(e2);
                throw new IllegalStateException(String.format("can't find %s#%s%s", klass.getName(), methodName, Arrays.asList(parameterTypes)), e);
            }
        }
    }

    public static Optional<Method> safeMethodLookup(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return Optional.of(klass.getMethod(methodName, parameterTypes));
        }
        catch (ReflectiveOperationException | SecurityException ignored) {
            try {
                return Optional.of(klass.getDeclaredMethod(methodName, parameterTypes));
            }
            catch (ReflectiveOperationException | SecurityException ignored2) {
                return Optional.empty();
            }
        }
    }

    public static <T> Optional<T> createInstanceIfPossible(CheckedCallable<T> creator) {
        try {
            return Optional.of(creator.call());
        }
        catch (InvocationTargetException e) {
            throw Sneaky.throwAnyway(e.getCause());
        }
        catch (ReflectiveOperationException | SecurityException ignored) {
            return Optional.empty();
        }
        catch (Throwable t) {
            throw Sneaky.throwAnyway(t);
        }
    }

    public static Stream<Class<?>> superTypes(Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        Set result = Stream.concat(Arrays.stream(interfaces).flatMap(JdbiClassUtils::superTypes), Arrays.stream(interfaces)).collect(Collectors.toSet());
        return result.stream();
    }

    public static Object[] safeVarargs(Object ... args) {
        return args == null ? NO_ARGS : args;
    }
}

