/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.async.AbstractJdbiExecutor;
import org.jdbi.v3.core.internal.exceptions.CheckedFunction;
import org.jdbi.v3.meta.Beta;

@Beta
class JdbiExecutorImpl
extends AbstractJdbiExecutor {
    private final Jdbi jdbi;
    private final Executor executor;

    JdbiExecutorImpl(Jdbi jdbi, Executor executor) {
        this.jdbi = jdbi;
        this.executor = executor;
    }

    @Override
    protected <T> CompletionStage<T> withExecute(CheckedFunction<Jdbi, T> callback) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return callback.apply(this.jdbi);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }, this.executor);
    }
}

