/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.ldap;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Objects;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public final class LdapSslSocketFactory
extends SocketFactory {
    private static final ThreadLocal<SSLContext> SSL_CONTEXT = new ThreadLocal();
    private final SocketFactory socketFactory;

    public LdapSslSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = Objects.requireNonNull(socketFactory, "socketFactory is null");
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localAddress, localPort);
    }

    public static SocketFactory getDefault() {
        SSLContext sslContext = SSL_CONTEXT.get();
        Preconditions.checkState((sslContext != null ? 1 : 0) != 0, (Object)"SSLContext was not set");
        return new LdapSslSocketFactory(sslContext.getSocketFactory());
    }

    public static void setSslContextForCurrentThread(SSLContext sslContext) {
        SSL_CONTEXT.set(sslContext);
    }
}

