/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import java.util.Locale;

final class ClientAddressAndPortExtractor<REQUEST>
implements FallbackAddressPortExtractor<REQUEST> {
    private final HttpServerAttributesGetter<REQUEST, ?> getter;

    ClientAddressAndPortExtractor(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(FallbackAddressPortExtractor.AddressPortSink sink, REQUEST request) {
        for (String forwarded : this.getter.getHttpRequestHeader(request, "forwarded")) {
            if (!ClientAddressAndPortExtractor.extractFromForwardedHeader(sink, forwarded)) continue;
            return;
        }
        for (String forwardedFor : this.getter.getHttpRequestHeader(request, "x-forwarded-for")) {
            if (!ClientAddressAndPortExtractor.extractFromForwardedForHeader(sink, forwardedFor)) continue;
            return;
        }
    }

    private static boolean extractFromForwardedHeader(FallbackAddressPortExtractor.AddressPortSink sink, String forwarded) {
        int start = forwarded.toLowerCase(Locale.ROOT).indexOf("for=");
        if (start < 0) {
            return false;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return false;
        }
        int end = forwarded.indexOf(59, start);
        if (end < 0) {
            end = forwarded.length();
        }
        return ClientAddressAndPortExtractor.extractClientInfo(sink, forwarded, start, end);
    }

    private static boolean extractFromForwardedForHeader(FallbackAddressPortExtractor.AddressPortSink sink, String forwardedFor) {
        return ClientAddressAndPortExtractor.extractClientInfo(sink, forwardedFor, 0, forwardedFor.length());
    }

    private static boolean extractClientInfo(FallbackAddressPortExtractor.AddressPortSink sink, String forwarded, int start, int end) {
        if (start >= end) {
            return false;
        }
        if (forwarded.charAt(start) == '\"') {
            int quoteEnd = forwarded.indexOf(34, start + 1);
            if (ClientAddressAndPortExtractor.notFound(quoteEnd, end)) {
                return false;
            }
            return ClientAddressAndPortExtractor.extractClientInfo(sink, forwarded, start + 1, quoteEnd);
        }
        if (forwarded.charAt(start) == '[') {
            int ipv6End = forwarded.indexOf(93, start + 1);
            if (ClientAddressAndPortExtractor.notFound(ipv6End, end)) {
                return false;
            }
            sink.setAddress(forwarded.substring(start + 1, ipv6End));
            int portStart = ipv6End + 1;
            if (portStart < end && forwarded.charAt(portStart) == ':') {
                int portEnd = ClientAddressAndPortExtractor.findPortEnd(forwarded, portStart + 1, end);
                ClientAddressAndPortExtractor.setPort(sink, forwarded, portStart + 1, portEnd);
            }
            return true;
        }
        boolean inIpv4 = false;
        for (int i = start; i < end; ++i) {
            boolean isIpv4PortSeparator;
            char c = forwarded.charAt(i);
            if (c == '.') {
                inIpv4 = true;
            }
            boolean bl = isIpv4PortSeparator = inIpv4 && c == ':';
            if (c != ',' && c != ';' && c != '\"' && !isIpv4PortSeparator) continue;
            if (i == start) {
                return false;
            }
            sink.setAddress(forwarded.substring(start, i));
            if (isIpv4PortSeparator) {
                int portStart = i;
                int portEnd = ClientAddressAndPortExtractor.findPortEnd(forwarded, portStart + 1, end);
                ClientAddressAndPortExtractor.setPort(sink, forwarded, portStart + 1, portEnd);
            }
            return true;
        }
        sink.setAddress(forwarded.substring(start, end));
        return true;
    }

    private static boolean notFound(int pos, int end) {
        return pos < 0 || pos >= end;
    }

    private static int findPortEnd(String header, int start, int end) {
        int numberEnd;
        for (numberEnd = start; numberEnd < end && Character.isDigit(header.charAt(numberEnd)); ++numberEnd) {
        }
        return numberEnd;
    }

    private static void setPort(FallbackAddressPortExtractor.AddressPortSink sink, String header, int start, int end) {
        if (start == end) {
            return;
        }
        try {
            sink.setPort(Integer.parseInt(header.substring(start, end)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

