/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.WriteFunction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

public interface ObjectWriteFunction
extends WriteFunction {
    @Override
    public Class<?> getJavaType();

    public void set(PreparedStatement var1, int var2, Object var3) throws SQLException;

    public static <T> ObjectWriteFunction of(final Class<T> javaType, final ObjectWriteFunctionImplementation<T> implementation) {
        Objects.requireNonNull(javaType, "javaType is null");
        Objects.requireNonNull(implementation, "implementation is null");
        return new ObjectWriteFunction(){

            public Class<T> getJavaType() {
                return javaType;
            }

            @Override
            public void set(PreparedStatement statement, int index, Object value) throws SQLException {
                implementation.set(statement, index, value);
            }
        };
    }

    @FunctionalInterface
    public static interface ObjectWriteFunctionImplementation<T> {
        public void set(PreparedStatement var1, int var2, T var3) throws SQLException;
    }
}

