/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.spi.connector.SortOrder;
import java.util.Objects;

@Immutable
public final class JdbcSortItem {
    private final JdbcColumnHandle column;
    private final SortOrder sortOrder;

    @JsonCreator
    public JdbcSortItem(JdbcColumnHandle column, SortOrder sortOrder) {
        this.column = Objects.requireNonNull(column, "column is null");
        this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder is null");
    }

    @JsonProperty
    public JdbcColumnHandle getColumn() {
        return this.column;
    }

    @JsonProperty
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcSortItem that = (JdbcSortItem)o;
        return this.sortOrder == that.sortOrder && Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.sortOrder);
    }

    public String toString() {
        return this.column + " " + this.sortOrder;
    }
}

