/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.server;

import com.singlestore.jdbc.ServerPreparedStatement;
import com.singlestore.jdbc.client.Client;
import com.singlestore.jdbc.client.Column;
import com.singlestore.jdbc.client.Completion;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.socket.Reader;
import com.singlestore.jdbc.export.Prepare;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.IOException;
import java.sql.SQLException;

public class PrepareResultPacket
implements Completion,
Prepare {
    private final Column[] parameters;
    private Column[] columns;
    protected int statementId;

    public PrepareResultPacket(ReadableByteBuf buffer, Reader reader, Context context) throws IOException {
        int i;
        Logger logger = Loggers.getLogger(PrepareResultPacket.class);
        boolean trace = logger.isTraceEnabled();
        buffer.readByte();
        this.statementId = buffer.readInt();
        int numColumns = buffer.readUnsignedShort();
        int numParams = buffer.readUnsignedShort();
        this.parameters = new Column[numParams];
        this.columns = new Column[numColumns];
        if (numParams > 0) {
            for (i = 0; i < numParams; ++i) {
                this.parameters[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), (context.getServerCapabilities() & 0x800000000L) > 0L);
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
        if (numColumns > 0) {
            for (i = 0; i < numColumns; ++i) {
                this.columns[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), (context.getServerCapabilities() & 0x800000000L) > 0L);
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
    }

    @Override
    public void close(Client con) throws SQLException {
        con.closePrepare(this);
    }

    @Override
    public void decrementUse(Client con, ServerPreparedStatement preparedStatement) throws SQLException {
        this.close(con);
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    @Override
    public Column[] getParameters() {
        return this.parameters;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(Column[] columns) {
        this.columns = columns;
    }
}

