/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcWriteValidation;
import io.trino.orc.OrcWriter;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.OutputStreamOrcDataSink;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.plugin.raptor.legacy.storage.OrcFileMetadata;
import io.trino.plugin.raptor.legacy.storage.RaptorStorageManager;
import io.trino.plugin.raptor.legacy.util.SyncingFileOutputStream;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrcFileWriter
implements Closeable {
    private static final JsonCodec<OrcFileMetadata> METADATA_CODEC = JsonCodec.jsonCodec(OrcFileMetadata.class);
    private final PageBuilder pageBuilder;
    private final OrcWriter orcWriter;
    private boolean closed;
    private long rowCount;
    private long uncompressedSize;

    public OrcFileWriter(TypeManager typeManager, List<Long> columnIds, List<Type> columnTypes, File target) {
        Preconditions.checkArgument((columnIds.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"ids and types mismatch");
        Preconditions.checkArgument((boolean)OrcFileWriter.isUnique(columnIds), (Object)"ids must be unique");
        List columnNames = (List)columnIds.stream().map(Objects::toString).collect(ImmutableList.toImmutableList());
        columnTypes = (List)columnTypes.stream().map(type -> RaptorStorageManager.toOrcFileType(type, typeManager)).collect(ImmutableList.toImmutableList());
        this.pageBuilder = new PageBuilder(columnTypes);
        ColumnMetadata orcTypes = OrcType.createRootOrcType((List)columnNames, (List)columnTypes);
        Map<String, String> metadata = OrcFileWriter.createFileMetadata(columnIds, columnTypes);
        this.orcWriter = OrcFileWriter.createOrcFileWriter(target, columnNames, columnTypes, (ColumnMetadata<OrcType>)orcTypes, metadata);
    }

    public void appendPages(List<Page> pages) {
        for (Page page : pages) {
            this.appendPage(page);
        }
    }

    public void appendPages(List<Page> pages, int[] pageIndexes, int[] positionIndexes) {
        Preconditions.checkArgument((pageIndexes.length == positionIndexes.length ? 1 : 0) != 0, (Object)"pageIndexes and positionIndexes do not match");
        for (int i = 0; i < pageIndexes.length; ++i) {
            Page page = pages.get(pageIndexes[i]);
            int position = positionIndexes[i];
            this.pageBuilder.declarePosition();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                Block block = page.getBlock(channel);
                BlockBuilder output = this.pageBuilder.getBlockBuilder(channel);
                this.pageBuilder.getType(channel).appendTo(block, position, output);
            }
            if (!this.pageBuilder.isFull()) continue;
            this.appendPage(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        if (!this.pageBuilder.isEmpty()) {
            this.appendPage(this.pageBuilder.build());
            this.pageBuilder.reset();
        }
    }

    private void appendPage(Page page) {
        this.rowCount += (long)page.getPositionCount();
        this.uncompressedSize += page.getLogicalSizeInBytes();
        try {
            this.orcWriter.write(page);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to write data", (Throwable)e);
        }
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.orcWriter.close();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to close writer", (Throwable)e);
        }
    }

    private static <T> boolean isUnique(Collection<T> items) {
        return new HashSet<T>(items).size() == items.size();
    }

    private static Map<String, String> createFileMetadata(List<Long> columnIds, List<Type> columnTypes) {
        ImmutableMap.Builder columnTypesMap = ImmutableMap.builder();
        for (int i = 0; i < columnIds.size(); ++i) {
            columnTypesMap.put((Object)columnIds.get(i), (Object)columnTypes.get(i).getTypeId());
        }
        OrcFileMetadata metadata = new OrcFileMetadata((Map<Long, TypeId>)columnTypesMap.buildOrThrow());
        return ImmutableMap.of((Object)"metadata", (Object)METADATA_CODEC.toJson((Object)metadata));
    }

    private static OrcDataSink createOrcDataSink(File target) {
        try {
            return OutputStreamOrcDataSink.create((OutputStream)new SyncingFileOutputStream(target));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_ERROR, "Failed to open output file: " + target, (Throwable)e);
        }
    }

    public static OrcWriter createOrcFileWriter(File target, List<String> columnNames, List<Type> types, ColumnMetadata<OrcType> orcTypes, Map<String, String> metadata) {
        return new OrcWriter(OrcFileWriter.createOrcDataSink(target), columnNames, types, orcTypes, CompressionKind.SNAPPY, new OrcWriterOptions(), metadata, true, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
    }
}

